<?php

namespace Drupal\a12s_maps_sync\Form;

use Drupal\Core\Entity\ContentEntityForm;
use Drupal\Core\Form\FormStateInterface;

/**
 * Form controller for the contextualized attribute entity edit forms.
 */
class ContextualizedAttributeForm extends ContentEntityForm {

  /**
   * {@inheritdoc}
   */
  public function save(array $form, FormStateInterface $form_state) {
    $result = parent::save($form, $form_state);

    $entity = $this->getEntity();

    $message_arguments = ['%label' => $entity->toLink()->toString()];
    $logger_arguments = [
      '%label' => $entity->label(),
      'link' => $entity->toLink($this->t('View'))->toString(),
    ];

    switch ($result) {
      case SAVED_NEW:
        $this->messenger()->addStatus($this->t('New contextualized attribute %label has been created.', $message_arguments));
        $this->logger('a12s_maps_sync')->notice('Created new contextualized attribute %label', $logger_arguments);
        break;

      case SAVED_UPDATED:
        $this->messenger()->addStatus($this->t('The contextualized attribute %label has been updated.', $message_arguments));
        $this->logger('a12s_maps_sync')->notice('Updated contextualized attribute %label.', $logger_arguments);
        break;
    }

    $form_state->setRedirect('entity.contextualized_attribute.collection');

    return $result;
  }

}
