<?php

namespace Drupal\a12s_maps_sync\Form;

use Drupal\a12s_maps_sync\BatchService;
use Drupal\Core\Form\FormStateInterface;
use Drupal\Core\StringTranslation\TranslatableMarkup;

/**
 * Class ConverterImportForm.
 */
class ConverterImportForm extends ImportForm {

  /**
   * Title callback.
   *
   * @return \Drupal\Core\StringTranslation\TranslatableMarkup
   */
  public function title(): TranslatableMarkup {
    return $this->t("Import converter %converter", ['%converter' => \Drupal::request()->get('maps_sync_converter')->label()]);
  }

  /**
   * {@inheritdoc}
   */
  public function import(array $form, FormStateInterface $form_state): void {
    /** @var \Drupal\a12s_maps_sync\Entity\ConverterInterface $converter */
    $converter = $this->entity;

    if ($form_state->getValue('import_type') === 'full') {
      $converter->resetLastImportedTime();
    }

    $batch = BatchService::getConverterImportBatchDefinition(
      $converter,
      $form_state->getValue('batch_size', 0),
    );

    batch_set($batch);
  }

}
