<?php

namespace Drupal\a12s_maps_sync\Maps;

use Drupal\a12s_maps_sync\Entity\Profile;

class Base implements BaseInterface {

  /**
   * The MaPS System ID.
   *
   * @var int
   */
  protected $id;

  /**
   * The source profile name.
   *
   * @var string
   */
  protected ?string $profile;

  /**
   * The source converter name.
   *
   * @var string
   */
  protected ?string $converter;

  /**
   * @var int
   */
  protected int $imported;

  /**
   * The object attributes.
   *
   * @var \Drupal\a12s_maps_sync\Maps\Attribute[]
   */
  protected $attributes = [];

  /**
   * Constructs a new MapsObject object.
   */
  public function __construct() {
    $this->attributes = new \ArrayObject();
  }

  /**
   * {@inheritdoc}
   */
  public function getId(): int {
    return $this->id;
  }

  /**
   * {@inheritdoc}
   */
  public function setId(int $id): Base {
    $this->id = $id;
    return $this;
  }

  /**
   * {@inheritdoc}
   */
  public function getProfile(): string {
    return $this->profile;
  }

  /**
   * {@inheritdoc}
   */
  public function setProfile(string $profile): Base {
    $this->profile = $profile;
    return $this;
  }

  /**
   * {@inheritdoc}
   */
  public function getConverter(): string {
    return $this->converter;
  }

  /**
   * {@inheritdoc}
   */
  public function setConverter(string $converter): Base {
    $this->converter = $converter;
    return $this;
  }

  /**
   * {@inheritDoc}
   * @todo merge with "get" method ?
   */
  public function getCountValues(string $name): int {
    // @todo Find a better way to manage this.
    if (str_starts_with($name, 'const:')) {
      return 1;
    }

    if (!empty($this->attributes[$name])) {
      return $this->attributes[$name]->getCountValue();
    }

    return 0;
  }

  /**
   * {@inheritdoc}
   */
  public function getAttribute(string $attributeName): ?Attribute {
    return $this->attributes[$attributeName] ?? NULL;
  }

  /**
   * {@inheritDoc}
   */
  public function get(string $name, int $language_id = NULL, $delta = NULL) {
    if (isset($this->attributes[$name])) {
      if (is_null($delta)) {
        $attribute = $this->attributes[$name]->getValue($language_id);
      }
      else {
        $attribute = $this->attributes[$name]->getValue($language_id, $delta);
      }
    }

    if (!empty($attribute)) {
      $values = $attribute['value'];

      if (is_null($values)) {
        // Try with the default language.
        $profile = Profile::load($this->profile);
        return $this->get($name, $profile->getDefaultMapslanguage(), $delta);
      }

      return $values;
    }

    return NULL;
  }

  /**
   * {@inheritDoc}
   */
  public function setAttributes(array $attributes): BaseInterface {
    $this->attributes->exchangeArray($attributes);
    return $this;
  }

  /**
   * @return int
   */
  public function getImported(): int {
    return $this->imported;
  }

  /**
   * @param int $imported
   *
   * @return Base
   */
  public function setImported(int $imported): Base {
    $this->imported = $imported;
    return $this;
  }

}
