<?php

namespace Drupal\a12s_maps_sync\Maps;

interface LibraryInterface extends BaseInterface {

  /**
   * @return string
   */
  public function getCode(): string;

  /**
   * @param string $code
   *
   * @return Library
   */
  public function setCode(string $code): Library;

  /**
   * @return int
   */
  public function getIdAttribute(): int;

  /**
   * @param int $id_attribute
   *
   * @return Library
   */
  public function setIdAttribute(int $id_attribute): Library;

  /**
   * @param int|null $id_language
   * @return mixed array|string
   *   If an id language is provided, we return the value for the given language.
   *   Else, we return values for all languages
   */
  public function getValue(int $id_language = NULL);

  /**
   * @param array $value
   *
   * @return Library
   */
  public function setValue(array $value): Library;

  /**
   * {@inheritdoc}
   */
  public function getValueByLanguage(int $id_language): ?string;

  /**
   * {@inheritdoc}
   */
  public function setValueByLanguage(int $id_language, string $value): Library;

}
