<?php

namespace Drupal\a12s_maps_sync\Maps;

interface LinkInterface extends BaseInterface {

  /**
   * @return int
   */
  public function getSourceId(): int;

  /**
   * @param int $source_id
   *
   * @return \Drupal\a12s_maps_sync\Maps\Link
   */
  public function setSourceId(int $source_id): Link;

  /**
   * @return int
   */
  public function getTargetId(): int;

  /**
   * @param int $target_id
   *
   * @return \Drupal\a12s_maps_sync\Maps\Link
   */
  public function setTargetId(int $target_id): Link;

  /**
   * @return int
   */
  public function getTypeId(): int;

  /**
   * @param int $type_id
   *
   * @return \Drupal\a12s_maps_sync\Maps\Link
   */
  public function setTypeId(int $type_id): Link;

  /**
   * @return int
   */
  public function getCount(): int;

  /**
   * @param int $count
   *
   * @return \Drupal\a12s_maps_sync\Maps\Link
   */
  public function setCount(int $count): Link;

}
