<?php

namespace Drupal\a12s_maps_sync\Plugin\MappingHandler;

use Drupal\a12s_maps_sync\Converter\Mapping;
use Drupal\a12s_maps_sync\Entity\ConverterInterface;
use Drupal\a12s_maps_sync\Entity\Profile;
use Drupal\a12s_maps_sync\Maps\BaseInterface;
use Drupal\a12s_maps_sync\Plugin\MappingHandlerPluginBase;
use Drupal\Core\Entity\EntityInterface;
use Drupal\Core\Language\LanguageInterface;

/**
 * Plugin implementation of the a12s_maps_sync_mapping_handler.
 *
 * @MappingHandler(
 *   id = "default",
 *   label = @Translation("Default"),
 *   description = @Translation("Default.")
 * )
 */
class DefaultHandler extends MappingHandlerPluginBase {

  /**
   * {@inheritdoc}
   */
  public function mapData(EntityInterface $entity, BaseInterface $object, Mapping $mapping, int $mapsLanguage, ?LanguageInterface $language = NULL) {
    if ($entity->get($mapping->getTarget()) === NULL) {
      \Drupal::logger('a12s_maps_sync')->warning("No target {$mapping->getTarget()} on {$entity->getEntityTypeId()} {$entity->id()}");
      return NULL;
    }

    if (!$mapping->isAppend()) {
      $entity->{$mapping->getTarget()} = NULL;
    }

    $source = $mapping->getSource();

    $values = [];
    for ($i = 0; $i < $object->getCountValues($source); $i++) {
      $parts = explode('+', $source);
      foreach ($parts as &$part) {
        if (strpos($part, 'const:') === 0) {
          $part = str_replace('const:', '', $part);
        }
        else {
          $part = $object->get($part, $mapsLanguage, $i);
        }
      }

      $value = implode('', $parts);
      $value = $this->castValue($value);

      // Here, we have to manage a special case for empty values.
      // If the field is translatable, and we are not currently on the
      // default language, we must not reset the value.
      if ($entity->isTranslatable() && empty($value) && $language !== NULL && $language->getId() !== \Drupal::languageManager()
          ->getDefaultLanguage()
          ->getId()) {
        if ($profile = Profile::load($object->getProfile())) {
          $defaultMapsLanguage = $profile->getDefaultMapslanguage();

          if ($mapsLanguage !== $defaultMapsLanguage) {
            return $this->mapData($entity, $object, $mapping, $defaultMapsLanguage, $language);
          }
        }

        return;
      }

      $isMultiple = $this->isMultiple($entity, $mapping);
      if ($isMultiple) {
        $entity->get($mapping->getTarget())->appendItem(['value' => $value] + $this->getAdditionalFieldParameters());
        $values[] = $value;
      }
      else {
        $entity->get($mapping->getTarget())->value = $value;
        foreach ($this->getAdditionalFieldParameters() as $param => $paramValue) {
          $entity->get($mapping->getTarget())->{$param} = $paramValue;
        }

        $values = $value;
      }
    }

    return $values;
  }

}
