<?php

namespace Drupal\a12s_maps_sync\Plugin\MappingHandler;

use Drupal\a12s_maps_sync\Converter\Mapping;
use Drupal\a12s_maps_sync\Entity\ConverterInterface;
use Drupal\a12s_maps_sync\Exception\MapsException;
use Drupal\a12s_maps_sync\Maps\BaseInterface;
use Drupal\a12s_maps_sync\Plugin\MappingHandlerPluginBase;
use Drupal\Core\Entity\EntityInterface;
use Drupal\Core\Form\FormStateInterface;
use Drupal\Core\Language\LanguageInterface;

/**
 * Plugin implementation of the a12s_maps_sync_mapping_handler.
 *
 * @MappingHandler(
 *   id = "link",
 *   label = @Translation("Link"),
 *   description = @Translation("Link")
 * )
 */
class LinkHandler extends EntityReferenceHandler {

  /**
   * {@inheritdoc}
   */
  public function defaultConfiguration(): array {
    $configuration = parent::defaultConfiguration();
    $configuration += [
      'link_type' => '',
      'use_quantity_as_sequence' => FALSE,
    ];

    return $configuration;
  }

  /**
   * {@inheritdoc}
   */
  public function buildConfigurationForm(array $form, FormStateInterface $form_state): array {
    // @todo use dependency injection.
    /** @var \Drupal\a12s_maps_sync\MapsApi $mapsApi */
    $mapsApi = \Drupal::service('a12s_maps_sync.maps_api');

    /** @var ConverterInterface $converter */
    $converter = $this->getConfiguration()['source_converter'];
    $linkTypes = $mapsApi->getConfiguration($converter->getProfile(), ['type' => 'link_type']);

    $options = [];
    foreach ($linkTypes as $linkType) {
      $options[$linkType['id']] = $linkType['value'];
    }

    $form['link_type'] = [
      '#type' => 'select',
      '#title' => $this->t('Link type'),
      '#empty_option' => $this->t('- Select -'),
      '#options' => $options,
      '#default_value' => $this->getConfiguration()['link_type'],
      '#description' => $this->t('The MaPS link type.'),
    ];

    $form['use_quantity_as_sequence'] = [
      '#type' => 'checkbox',
      '#title' => $this->t('Use quantity as sequence'),
      '#description' => $this->t("Use the link's quantity as if it is a sequence to order links."),
      '#default_value' => $this->getConfiguration()['use_quantity_as_sequence'],
    ];

    return parent::buildConfigurationForm($form, $form_state);
  }

  /**
   * {@inheritdoc}
   */
  public function getObjectValue(ConverterInterface $converter, BaseInterface $object, Mapping $mapping, int $i) {
    $links = $object->getLinks(
      (string) $mapping->getOption('link_type'),
      (bool) $mapping->getOption('use_quantity_as_sequence'),
    );

    return !empty($links[$i]) ? $links[$i]->getTargetId() : NULL;
  }

}
