<?php

namespace Drupal\a12s_maps_sync\Plugin;

use Drupal\a12s_maps_sync\Converter\Mapping;
use Drupal\Component\Plugin\PluginBase;
use Drupal\Core\Entity\EntityInterface;
use Drupal\Core\Field\BaseFieldDefinition;
use Drupal\Core\Form\FormStateInterface;
use Drupal\Core\StringTranslation\StringTranslationTrait;

/**
 * Base class for a12s_maps_sync_mapping_handler plugins.
 */
abstract class MappingHandlerPluginBase extends PluginBase implements MappingHandlerInterface {

  use StringTranslationTrait;

  /**
   * {@inheritdoc}
   */
  public function label() {
    // Cast the label to a string since it is a TranslatableMarkup object.
    return (string) $this->pluginDefinition['label'];
  }

  /**
   * {@inheritdoc}
   */
  public function defaultConfiguration(): array {
    return [];
  }

  /**
   * {@inheritdoc}
   */
  public function getConfiguration(): array {
    return $this->configuration;
  }

  /**
   * {@inheritdoc}
   */
  public function setConfiguration(array $configuration): void {
    $this->configuration = $configuration + $this->defaultConfiguration();
  }

  /**
   * {@inheritdoc}
   */
  public function castValue($value) {
    return $value;
  }

  /**
   * {@inheritdoc}
   */
  public function getAdditionalFieldParameters(): array {
    return [];
  }

  /**
   * {@inheritdoc}
   */
  public function isMultiple(EntityInterface $entity, Mapping $mapping): bool {
    if ($mapping->getTarget() === 'parent') {
      return FALSE;
    }
    else {
      /** @var \Drupal\Core\Entity\EntityFieldManager $entityFieldManager */
      $entityFieldManager = \Drupal::service('entity_field.manager');
      $fields = $entityFieldManager->getFieldStorageDefinitions($entity->getEntityType()
        ->id());

      $field = $fields[$mapping->getTarget()];
      if ($field instanceof BaseFieldDefinition) {
        return $field->getCardinality() !== 1;
      }
      else {
        return $fields[$mapping->getTarget()]->get('cardinality') !== 1;
      }
    }
  }

  /**
   * {@inheritdoc}
   */
  public function buildConfigurationForm(array $form, FormStateInterface $form_state): array {
    return $form;
  }

  /**
   * {@inheritdoc}
   */
  public function validateConfigurationForm(array &$form, FormStateInterface $form_state): void {}

  /**
   * {@inheritdoc}
   */
  public function submitConfigurationForm(array &$form, FormStateInterface $form_state): void {}

}
