<?php

namespace Drupal\a12s_maps_sync\Plugin\SourceHandler;

use Drupal\a12s_maps_sync\Entity\ConverterInterface;

trait AttributesTrait {

  /**
   * Retrieves the attribute filters.
   *
   * @return array
   *   The attribute filters.
   *
   * @throws \Drupal\a12s_maps_sync\Exception\MapsApiException
   *   Thrown when there is an error retrieving attribute configuration from the Maps API.
   * @throws \GuzzleHttp\Exception\GuzzleException
   *   Thrown when there is an error making an HTTP request to the Maps API.
   */
  protected function getAttributesFilters(ConverterInterface $converter): array {
    // @todo use dependency injection.
    /** @var \Drupal\a12s_maps_sync\MapsApi $mapsApi */
    $mapsApi = \Drupal::service('a12s_maps_sync.maps_api');

    $attributeFilters = [];
    $attributes = $mapsApi->getConfiguration($converter->getProfile(), ['type' => 'attribute']);
    foreach ($attributes as $attribute) {
      $attributeFilters["attribute_" . $attribute['code']] = $attribute['value'] . "({$attribute['code']})";
    }
    if (!empty($attributeFilters)) {
      asort($attributeFilters);
    }

    return $attributeFilters;
  }

}
