<?php

namespace Drupal\a12s_maps_sync\Plugin;

use Drupal\a12s_maps_sync\Entity\ConverterInterface;
use Drupal\a12s_maps_sync\Entity\ProfileInterface;
use Drupal\a12s_maps_sync\Maps\BaseInterface;
use Drupal\Core\Entity\EntityInterface;
use Drupal\Core\Language\LanguageInterface;

/**
 * Interface for a12s_maps_sync_source_handler plugins.
 */
interface SourceHandlerInterface {

  /**
   * Returns the translated plugin label.
   *
   * @return string
   *   The translated title.
   */
  public function label();

  /**
   * @param \Drupal\a12s_maps_sync\Entity\ConverterInterface $converter
   * @param array $filters
   * @param int $limit
   * @param int $fromTime
   *
   * @return array
   */
  public function getData(ConverterInterface $converter, array $filters, int $limit, int $fromTime = 0): array;

  /**
   * @param \Drupal\a12s_maps_sync\Entity\ConverterInterface $converter
   * @param array $filters
   * @param int $fromTime
   *
   * @return int
   */
  public function getCountData(ConverterInterface $converter, array $filters, int $fromTime): int;

  /**
   * Returns the available filter types.
   *
   * @param \Drupal\a12s_maps_sync\Entity\ConverterInterface $converter
   *
   * @return array
   */
  public function getFilterTypes(ConverterInterface $converter): array;

  /**
   * Returns all available filter values.
   *
   * @param \Drupal\a12s_maps_sync\Entity\ConverterInterface $converter
   * @param string $type
   *
   * @return array
   */
  public function getFilterValues(ConverterInterface $converter, string $type): array;

  /**
   * Get the fixed mapping if it exists.
   *
   * @param \Drupal\a12s_maps_sync\Entity\ProfileInterface $profile
   *
   * @return array
   */
  public function getFixedMapping(ProfileInterface $profile): array;

  /**
   * Get the custom available mapping sources.
   *
   * @return array
   */
  public function getMappingSources(): array;

  /**
   * If the MaPS "entity" type manages attributes.
   *
   * @return bool
   */
  public function hasAttributes(): bool;

  /**
   * @param string $entity_type
   * @param string|NULL $bundle
   * @param \Drupal\a12s_maps_sync\Maps\BaseInterface $object
   * @param array $gid_definition
   * @param \Drupal\Core\Language\LanguageInterface|NULL $language
   *
   * @return mixed
   */
  public function getEntity(string $entity_type, string $bundle = NULL, BaseInterface $object, array $gid_definition, LanguageInterface $language = NULL);

  /**
   * @param array $definition
   * @param \Drupal\a12s_maps_sync\Maps\BaseInterface $object
   *
   * @return false|string
   */
  public function getGid(array $definition, BaseInterface $object): false|string;

  /**
   * @return array
   */
  public function getAllowedGidEntityKeys(): array;

  /**
   * @param \Drupal\a12s_maps_sync\Entity\ConverterInterface $converter
   * @param \Drupal\Core\Entity\EntityInterface $entity
   *
   * @return \Drupal\a12s_maps_sync\Maps\BaseInterface|null
   */
  public function findObjectFromEntity(ConverterInterface $converter, EntityInterface $entity): ?BaseInterface;

  /**
   * @param \Drupal\a12s_maps_sync\Entity\ConverterInterface $converter
   * @param \Drupal\Core\Entity\EntityInterface $entity
   *
   * @return array|null
   */
  public function getConditionFromGid(ConverterInterface $converter, EntityInterface $entity): ?array;

  /**
   * @return bool
   */
  public function isAttributable(): bool;

}
