<?php

namespace Drupal\a12s_maps_sync\Plugin;

use Drupal\Core\Cache\CacheBackendInterface;
use Drupal\Core\Extension\ModuleHandlerInterface;
use Drupal\Core\Plugin\DefaultPluginManager;

/**
 * A12sMapsSyncSourceHandler plugin manager.
 */
class SourceHandlerPluginManager extends DefaultPluginManager {

  /**
   * Constructs A12sMapsSyncSourceHandlerPluginManager object.
   *
   * @param \Traversable $namespaces
   *   An object that implements \Traversable which contains the root paths
   *   keyed by the corresponding namespace to look for plugin implementations.
   * @param \Drupal\Core\Cache\CacheBackendInterface $cache_backend
   *   Cache backend instance to use.
   * @param \Drupal\Core\Extension\ModuleHandlerInterface $module_handler
   *   The module handler to invoke the alter hook with.
   */
  public function __construct(\Traversable $namespaces, CacheBackendInterface $cache_backend, ModuleHandlerInterface $module_handler) {
    parent::__construct(
      'Plugin/SourceHandler',
      $namespaces,
      $module_handler,
      'Drupal\a12s_maps_sync\Plugin\SourceHandlerInterface',
      'Drupal\a12s_maps_sync\Annotation\SourceHandler'
    );
    $this->alterInfo('a12s_maps_sync_source_handler_info');
    $this->setCacheBackend($cache_backend, 'a12s_maps_sync_source_handler_plugins');
  }

}
