# a12s MaPS Sync

## Fonctionnement de l'import

Les flux sont importés grâce à un service Python qui stocke les données dans une table à part.
Le module Drupal lit ensuite les données dans cette base de données afin de créer les entités correspondantes dans Drupal.

## Configuration de la base de données du service Python

Configurer les variables d'environnement suivantes :

```
MAPS_SYNC_DATABASE_NAME=
MAPS_SYNC_DATABASE_USER=
MAPS_SYNC_DATABASE_PASSWORD=
MAPS_SYNC_DATABASE_HOST=
MAPS_SYNC_DATABASE_PORT=
MAPS_SYNC_DATABASE_DRIVER=
```

## Installation du module

Le module s'installe de manière classique :

`drupal module:install a12s_maps_sync`

## Configuration du module

### Configurer les types d'entités autorisés

Il est nécessaire de définir au préalable les types d'entités autorisés, afin de créer dynamiquement le champ GID MaPS, utilisé pour faire la correspondance entre les entités Drupal et les objets / médias MaPS.

La configuration se fait à l'adresse */admin/config/a12s_maps_sync/settings* (Menu *Configuration* -> *MaPS Sync* -> *Settings*).

## Configuration des profils

Un *Profile* est une entité personnalisé utilisée pour regrouper plusieurs convertisseurs utilisant un même flux.
La plupart du temps, nous aurons donc un profil par flux MaPS.

Pour ajouter un nouveau profil : */admin/a12s_maps_sync/profile* (Menu *Configuration* -> *MaPS Sync* -> *Profile* -> *Add MaPS Sync profile*)

La configuration du profil demande de définir l'identifiant (MaPS) de la langue utilisé par défaut dans MaPS. Ceci est nécessaire car suivant les flux, la langue par défaut n'est pas la même.
Dans la plus grande partie des cas, la langue à choisir sera soit le français (id 1) ou l'anglais (id 2). Il convient de vérifier dans les flux la langue à utiliser par défaut.

Il est également nécessaire d'indiquer le chemin du dossier dans lequel les médias sont déposés. Le chemin doit être défini intégralement, en utilisant une URI commençant par *public://* ou *private://*, sans slash à la fin.

*Exemple : public://maps_suite/collections/medias*

*Remarque : Pour la cohérence, il est préférable d'utiliser les mêmes noms machine pour les profils et les convertisseur dans le service Python et dans la configuration Drupal.*

## Configuration des convertisseurs

Une fois le profil créé, il est possible de créer des convertisseurs, définissant comment les objets MaPS vont être convertis dans Drupal.

À partir de la vue d'ensemble des profils (*/admin/a12s_maps_sync/profile*), via l'opération *Converters*, nous accédons à la vue d'ensemble des convertisseurs de ce profil, à partir de laquelle nous pouvons ajouter un nouveau convertisseur.

Pour chaque convertisseur, il faut définir les éléments suivants :

* Un **libellé** et un **nom machine**
* Un **"handler"** (par défaut, utiliser le handler *Default*, sauf pour des cas particuliers que nous détaillerons plus tard)
* Le **GID** :  définit comment le "GID" va être généré. Par défaut, le GID est **profile,id**, ce qui veut dire que le GID sera composé du nom machine du profile et de l'identifiant de l'objet MaPS. Si besoin, nous pouvons utiliser le préfixe *const:* pour utiliser une constante dans le GID.
* Le **type d'entité** à utiliser pour convertir l'objet MaPS
* Le **bundle** à utiliser pour convertir l'objet MaPS, si besoin
* Le **type de "l'entité MaPS"** : objet, média ou librairie
* Les **filtres** à utiliser pour identifier l'objet MaPS, au format YAML. Cette configuration va être semblable à celle utilisée dans la configuration du service Python. Quelques exemples suivront.
* Le **mapping** entre les attributs MaPS et les champs / propriétés Drupal, au format YAML. Voir exemples ci après.
* Les **statuts publiés** : définit les statuts MaPS à considérer comme "publié" (par exemple, 8 et 4), si besoin. Valeurs séparées par des virgules.
* Le type de **gestion des status** : permet de définir ce que l'on fait des objets non-publiés dans MaPS (suppression ou dépublication)



Les médias MaPS ne possédant aucun status, il est possible de définir, dans le cas d'un convertisseur de média, une propriété qui fera office de status :

- La **propriété** à utiliser comme status (à définir de la même manière qu'un élément de mapping, par exemple `attribute][name=USED_IN_WEB][current][0][value`)
- La **valeur** de cette propriété pour considérer le média comme étant publié (par exemple, `1`)



Les convertisseurs peuvent être ordonnés à partir de la vue d'ensemble des convertisseurs afin de définir dans quel ordre ils doivent être traités lors de l'import d'un profil.

### Exemples de filtres

**Filtrer sur le nom du convertisseur (tel que défini dans le service Python)**

```
converter: dial
```

------

**Filtrer sur une nature d'objet :**

```
object_nature: 22
```

-----

**Filtrer sur un type d'objet :**

```
object_type: 77
```

-----

**Filtrer sur une classe d'objet :**

```
object_class: 77
```

----

**Filtrer sur l'identifiant MaPS du parent :**

```
object_parent_id: 21816
```

----

**Filtrer sur le type "d'entité MaPS" (par exemple, "objet") :**

```
type: object
```

-----

**Filtrer sur l'identifiant d'une librairie :**

```
id_attribute: 380
```

-----

**Filtre sur l'attribut MEDIAIMGTYPE pour identifiant un média particulier :**

*Remarque : les filtres sur attributs ne sont pour le moment en place que pour les médias, pas pour les objets*

```
attribute_MEDIAIMGTYPE: 'idattribute_library:136'
```

-----

**Filtre les médias possédant une valeur pour un attribut donné**

```
attribute_DSPLUS_IMAGE_CONSTRAINTS: 'NOT EMPTY'
```

-----

**Filtre les médias ne possédant pas de valeur pour un attribut donné**

```
attribute_DSPLUS_IMAGE_CONSTRAINTS: EMPTY
```

### Exemples de mapping

**Mapping entre l'attribut LABEL et le champ name :**

```
'attribute][name=LABEL][current][0][value': name
```

----

**Mapping en spécifiant le format du champ :**

```
'attribute][name=ADDRESS][current][0][value':
  field_name: field_address
  format: html_full
```

----

**Mapping entre un attribut objet et un champ entity_reference :**

```
'attribute][name=POS_PAYS][current][0][value':
  field_name: field_pos_state_country
  converter: pos_country
```

----

**Mapping entre la valeur d'un attribut librairie et le champ name :**

```
value: name
```

----

**Mapping entre un attribut library et un champ entity_reference :**

```
'attribute][name=POS_TYPE][current][0][idattribute_library':
  field_name: field_pos_type
  converter: pos_type
```

----

**Mapping entre l'identifiant du parent MaPS et le parent d'un terme de taxonomie :**

```
parent_id:
  field_name: parent
  converter: collection
```

----

**Mapping entre les médias MaPS et un champ entity_reference (à vérifier) :**

```
medias:
  converter: watch_image
  field_name: field_watch_images
  entity_type: media
```

Dans le cas des médias uniquement, on peut avoir plusieurs convertisseurs. Dans ce cas, il est possible de créer des sous-mapping :

```
medias:
  -
    converter: watch_image
    field_name: field_watch_images
    entity_type: media
  -
    converter: watch_image_home
    field_name: field_watch_home_images
    entity_type: media
```

## Commandes disponibles

Des commandes sont disponibles pour importer et effectuer un rollback (le rollback consiste simplement en la suppression des données importées. Pour celà, on supprime toutes les entités en se basant sur l'entity type et le bundle défini dans le convertisseur).

Ces commandes sont exécutables au niveau des profils et des convertisseurs.

### Importer un profil

`drush a12s_maps_sync:import:profile profile_name`

**Alias**

`drush amsip profile_name`

**Options**

* --limit=100 : *définit le nombre d'éléments à importer*
* --force=true : *bypass le lock*

### Importer un convertisseur

`drush a12s_maps_sync:import:converter converter_name`

**Alias**

`drush amsic converter_name`

**Options**

* --limit=100 : *définit le nombre d'éléments à importer*
* --force=true : *bypass le lock*

### Rollback un profil

**ATTENTION : CETTE COMMAND SUPPRIME LES DONNEES DRUPAL**

`drush a12s_maps_sync:rollback:profile profile_name`

**Alias**

`drush amsrp profile_name`

### Rollback un convertisseur

**ATTENTION : CETTE COMMAND SUPPRIME LES DONNEES DRUPAL**

`drush a12s_maps_sync:rollback:converter converter_name`

**Alias**

`drush amsrp converter_name`

### Libérer un lock

L'import créé un lock, qui est automatiquement libéré à la fin de l'import.
Cependant, pour le libérer manuellement :

`drush a12s_maps_sync:release_lock profile_name`

Les locks sont, pour le moment, uniquement définis au niveau du profil.

**Alias**

`drush amsrl profile_name`

