<?php

namespace Drupal\a12s_maps_sync\Entity;

use Drupal\a12s_maps_sync\Maps\MapsBaseManagerInterface;
use Drupal\a12s_maps_sync\Plugin\MapsSyncHandlerInterface;
use Drupal\Core\Config\Entity\ConfigEntityInterface;

/**
 * Provides an interface for defining Maps sync converter entities.
 */
interface MapsSyncConverterInterface extends ConfigEntityInterface {

  /** @var string  */
  public const STATUS_MANAGEMENT_UNPUBLISH = 'unpublish';

  /** @var string  */
  public const STATUS_MANAGEMENT_DELETE = 'delete';

  /** @var string  */
  public const STATUS_MANAGEMENT_UPDATE_EXISTING_IGNORE_STATUS = 'update_existing_ignore_status';

  /**
   * @return \Drupal\a12s_maps_sync\Entity\MapsSyncProfileInterface
   */
  public function getProfile(): ?MapsSyncProfileInterface;

  /**
   * @param string $profile_id
   * @return \Drupal\a12s_maps_sync\Entity\MapsSyncConverterInterface
   */
  public function setProfileId(string $profile_id): MapsSyncConverterInterface;

  /**
   * @return string
   */
  public function getConverterEntityType(): ?string;

  /**
   * @param string $entity_type
   * @return \Drupal\a12s_maps_sync\Entity\MapsSyncConverterInterface
   */
  public function setConverterEntityType(string $entity_type): MapsSyncConverterInterface;

  /**
   * @return string
   */
  public function getConverterBundle(): ?string;

  /**
   * @param string $bundle
   * @return \Drupal\a12s_maps_sync\Entity\MapsSyncConverterInterface
   */
  public function setConverterBundle(string $bundle): MapsSyncConverterInterface;

  /**
   * @return array
   */
  public function getFilters(): ?array;

  /**
   * @param array $filters
   * @return \Drupal\a12s_maps_sync\Entity\MapsSyncConverterInterface
   */
  public function setFilters(array $filters): MapsSyncConverterInterface;

  /**
   * @return array
   */
  public function getMapping(): array;

  /**
   * @param array $mapping
   * @return \Drupal\a12s_maps_sync\Entity\MapsSyncConverterInterface
   */
  public function setMapping(array $mapping): MapsSyncConverterInterface;

  /**
   * @return array
   */
  public function getPublishedStatuses(): array;

  /**
   * @param array $statuses
   * @return \Drupal\a12s_maps_sync\Entity\MapsSyncConverterInterface
   */
  public function setPublishedStatuses(array $statuses): MapsSyncConverterInterface;

  /**
   * @return string
   */
  public function getStatusManagement(): ?string;

  /**
   * @param string $statusManagement
   * @return \Drupal\a12s_maps_sync\Entity\MapsSyncConverterInterface
   */
  public function setStatusManagement(string $statusManagement): MapsSyncConverterInterface;

  /**
   * @return string
   */
  public function getMediaStatusProperty(): ?string;

  /**
   * @param string $mediaStatusProperty
   * @return \Drupal\a12s_maps_sync\Entity\MapsSyncConverterInterface
   */
  public function setMediaStatusProperty(string $mediaStatusProperty): MapsSyncConverterInterface;

  /**
   * @return string
   */
  public function getMediaStatusPublishedValue(): ?string;

  /**
   * @param string $publishedValue
   * @return \Drupal\a12s_maps_sync\Entity\MapsSyncConverterInterface
   */
  public function setMediaStatusPublishedValue(string $publishedValue): MapsSyncConverterInterface;

  /**
   * @return array
   */
  public function getGid(): array;

  /**
   * @param array $gid
   * @return \Drupal\a12s_maps_sync\Entity\MapsSyncConverterInterface
   */
  public function setGid(array $gid): MapsSyncConverterInterface;

  /**
   * @return string
   */
  public function getMapsType(): ?string;

  /**
   * @param string $type
   * @return \Drupal\a12s_maps_sync\Entity\MapsSyncConverterInterface
   */
  public function setMapsType(string $type): MapsSyncConverterInterface;

  /**
   * @return string
   */
  public function getParentId(): ?string;

  /**
   * @param string $parent_id
   * @return \Drupal\a12s_maps_sync\Entity\MapsSyncConverterInterface
   */
  public function setParentId(string $parent_id): MapsSyncConverterInterface;

  /**
   * @return \Drupal\a12s_maps_sync\Entity\MapsSyncConverterInterface
   */
  public function getParent(): ?MapsSyncConverterInterface;

  /**
   * @return int
   */
  public function getWeight(): ?int;

  /**
   * @param int $weight
   * @return \Drupal\a12s_maps_sync\Entity\MapsSyncConverterInterface
   */
  public function setWeight(int $weight): MapsSyncConverterInterface;

  /**
   * @return \Drupal\a12s_maps_sync\Maps\MapsSyncHandlerInterface
   */
  public function getHandler(): MapsSyncHandlerInterface;

  /**
   * @return string
   */
  public function getHandlerId(): ?string;

  /**
   * @param string $handler_id
   * @return \Drupal\a12s_maps_sync\Entity\MapsSyncConverterInterface
   */
  public function setHandlerId(string $handler_id): MapsSyncConverterInterface;

  /**
   * @return \Drupal\a12s_maps_sync\Maps\MapsBaseManagerInterface
   */
  public function getMapsManager(): MapsBaseManagerInterface;

  /**
   * Process the converter import.
   *
   * @return mixed
   */
  public function import($limit): array;

  /**
   * Process a rollback by deleting all entities matching the current converter.
   * We based our query on the entity type and bundle defined in the converter.
   *
   * @return mixed
   */
  public function rollback();

}
