<?php

namespace Drupal\a12s_maps_sync\Entity;

use Drupal\Core\Config\Entity\ConfigEntityInterface;

/**
 * Provides an interface for defining MaPS Sync profile entities.
 */
interface MapsSyncProfileInterface extends ConfigEntityInterface {

  /**
   * Get all converters of the profile.
   *
   * @return array
   */
  public function getConverters(): array;

  /**
   * Get the default MaPS language id.
   *
   * @return int
   */
  public function getDefaultMapsLanguage(): ?int;

  /**
   * Set the default MaPS language id.
   *
   * @param int $language
   * @return \Drupal\a12s_maps_sync\Entity\MapsSyncProfileInterface
   */
  public function setDefaultMapsLanguage(int $language): MapsSyncProfileInterface;

  /**
   * Get the medias path.
   *
   * @return string|null
   */
  public function getMediasPath(): ?string;

  /**
   * Set the medias path.
   *
   * @param string $medias_path
   * @return \Drupal\a12s_maps_sync\Entity\MapsSyncProfileInterface
   */
  public function setMediasPath(string $medias_path): MapsSyncProfileInterface;

}
