<?php

namespace Drupal\a12s_maps_sync\Event;

use Drupal\a12s_maps_sync\Entity\MapsSyncConverterInterface;
use Drupal\a12s_maps_sync\Maps\MapsBaseInterface;
use Drupal\Component\EventDispatcher\Event;
use Drupal\Core\Entity\EntityInterface;
use Drupal\Core\Language\LanguageInterface;

class ConverterItemImportEvent extends Event {

  const FINISHED = 'a12s_maps_sync_converter_item_import_finished';

  /** @var MapsSyncConverterInterface */
  public $converter;

  /** @var MapsBaseInterface */
  public $object;

  /** @var EntityInterface */
  public $entity;

  /** @var LanguageInterface */
  public $language;

  /**
   * @param MapsSyncConverterInterface $converter
   * @param MapsBaseInterface $object
   * @param EntityInterface $entity
   * @param LanguageInterface|null $language
   */
  public function __construct(MapsSyncConverterInterface $converter, MapsBaseInterface $object, EntityInterface $entity, ?LanguageInterface $language) {
    $this->converter = $converter;
    $this->object = $object;
    $this->entity = $entity;
    $this->language = $language;
  }

}
