<?php

namespace Drupal\a12s_maps_sync\Form;

use Drupal\a12s_maps_sync\Maps\MapsBaseInterface;
use Drupal\Core\Form\FormBase;
use Drupal\Core\Form\FormStateInterface;
use Drupal\Core\Url;

class DashboardForm extends FormBase {

  /**
   * {@inheritdoc}
   */
  public function getFormId() {
    return 'a12s_maps_sync.dashboard_form';
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state) {
    $form['gid'] = [
      '#type' => 'textfield',
      '#title' => $this->t('GID'),
      '#description' => $this->t('The MaPS GID. You can use % as wildcards'),
    ];

    $form['actions'] = array('#type' => 'actions');
    $form['actions']['submit'] = [
      '#type' => 'submit',
      '#value' => $this->t('Search'),
    ];

    $entities = $form_state->getValue('entities');
    if (!empty($entities)) {
      $form['entities'] = [
        '#type' => 'table',
        '#header' => [
          $this->t('Label'),
          $this->t('GID'),
          $this->t('Entity type'),
          $this->t('Bundle'),
          $this->t('Operations')
        ],
        '#empty' => $this->t('No entity found'),
      ];

      foreach ($entities as $entity_type => $ids) {
        foreach ($ids as $id) {
          $entity = \Drupal::entityTypeManager()->getStorage($entity_type)->load($id);

          $form['entities'][$id] = [
            'label' => [
              '#plain_text' => $entity->label(),
            ],
            'gid' => [
              '#plain_text' => $entity->get(MapsBaseInterface::GID_FIELD)->value,
            ],
            'entity_type' => [
              '#plain_text' => $entity->getEntityType()->getLabel(),
            ],
            'bundle' => [
              '#plain_text' => $entity->bundle(),
            ],
            'operations' => [
              '#type' => 'operations',
              '#links' => [],
            ],
          ];

          if ($entity->hasLinkTemplate('canonical')) {
            $form['entities'][$id]['operations']['#links']['view'] = [
              'title' => t('View'),
              'url' => Url::fromRoute("entity.$entity_type.canonical", [$entity_type => $entity->id()]),
            ];
          }

          if ($entity->hasLinkTemplate('edit')) {
            $form['entities'][$id]['operations']['#links']['edit'] = [
              'title' => t('Edit'),
              'url' => Url::fromRoute("entity.$entity_type.edit_form", [$entity_type => $entity->id()]),
            ];
          }
        }
      }
    }

    return $form;
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state) {
    $config = $this->config('a12s_maps_sync.settings');
    $entity_types = array_filter($config->get('allowed_entity_types'));

    $entities = [];
    foreach ($entity_types as $entity_type) {
      $entities[$entity_type] = \Drupal::entityQuery($entity_type)
        ->accessCheck()
        ->condition(MapsBaseInterface::GID_FIELD, $form_state->getValue('gid'), 'LIKE')
        ->execute();
    }

    $form_state->setRebuild(TRUE);
    $form_state->setValue('entities', $entities);
  }

}
