<?php

namespace Drupal\a12s_maps_sync\Form;

use Drupal\Core\Entity\EntityForm;
use Drupal\Core\Form\FormStateInterface;

/**
 * Class MapsSyncProfileForm.
 */
class MapsSyncProfileForm extends EntityForm {

  /**
   * {@inheritdoc}
   */
  public function form(array $form, FormStateInterface $form_state) {
    $form = parent::form($form, $form_state);

    /** @var \Drupal\a12s_maps_sync\Entity\MapsSyncProfileInterface $maps_sync_profile */
    $maps_sync_profile = $this->entity;
    $form['label'] = [
      '#type' => 'textfield',
      '#title' => $this->t('Label'),
      '#maxlength' => 255,
      '#default_value' => $maps_sync_profile->label(),
      '#description' => $this->t('Label for the MaPS Sync profile.'),
      '#required' => TRUE,
    ];

    $form['id'] = [
      '#type' => 'machine_name',
      '#default_value' => $maps_sync_profile->id(),
      '#machine_name' => [
        'exists' => '\Drupal\a12s_maps_sync\Entity\MapsSyncProfile::load',
      ],
      '#disabled' => !$maps_sync_profile->isNew(),
    ];

    $form['default_maps_language'] = [
      '#title' => $this->t('Default MaPS language'),
      '#type' => 'number',
      '#default_value' => $maps_sync_profile->getDefaultMapsLanguage() ?: 1,
      '#required' => TRUE,
      '#description' => $this->t('The default MaPS language id. 1 is French, 2 is English, ...'),
    ];

    $form['medias_path'] = [
      '#title' => $this->t('Medias path'),
      '#type' => 'textfield',
      '#default_value' => $maps_sync_profile->getMediasPath(),
      '#description' => $this->t('The full path to the medias folder. You must use public:// or private://. NO trailing slash. Example: public://maps_suite/collections/medias')
    ];

    return $form;
  }

  /**
   * {@inheritdoc}
   */
  public function save(array $form, FormStateInterface $form_state) {
    $maps_sync_profile = $this->entity;
    $status = $maps_sync_profile->save();

    switch ($status) {
      case SAVED_NEW:
        \Drupal::messenger()->addMessage($this->t('Created the %label MaPS Sync profile.', [
          '%label' => $maps_sync_profile->label(),
        ]));
        break;

      default:
        \Drupal::messenger()->addMessage($this->t('Saved the %label MaPS Sync profile.', [
          '%label' => $maps_sync_profile->label(),
        ]));
    }
    $form_state->setRedirectUrl($maps_sync_profile->toUrl('collection'));
  }

}
