<?php

namespace Drupal\a12s_maps_sync\Form;

use Drupal\Core\Form\ConfigFormBase;
use Drupal\Core\Form\FormStateInterface;

/**
 * Class SettingsForm.
 */
class SettingsForm extends ConfigFormBase {

  /**
   * {@inheritdoc}
   */
  protected function getEditableConfigNames() {
    return [
      'a12s_maps_sync.settings',
    ];
  }

  /**
   * {@inheritdoc}
   */
  public function getFormId() {
    return 'settings_form';
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state) {
    $config = $this->config('a12s_maps_sync.settings');

    $default = [
      'taxonomy_term',
      'media',
      'file',
      'content',
    ];

    $entity_types = \Drupal::entityTypeManager()->getDefinitions();
    $options = [];
    foreach ($entity_types as $entity_type) {
      $options[$entity_type->id()] = $entity_type->getLabel();
    }

    $form['allowed_entity_types'] = [
      '#type' => 'checkboxes',
      '#title' => $this->t('Allowed entity types'),
      '#description' => $this->t('The entity types allowed to be converted through the import.'),
      '#options' => $options,
      '#default_value' => $config->get('allowed_entity_types') ?: $default,
    ];

    $form['ignore_lock'] = [
      '#type' => 'checkbox',
      '#title' => $this->t('Ignore the lock management'),
      '#description' => $this->t('Ignore the lock management during import, for whatever reason. It is the same thing as launching every command with the --force=true option.'),
      '#default_value' => $config->get('ignore_lock') ?: FALSE,
    ];

    $form['import_batch_size'] = [
      '#type' => 'number',
      '#title' => $this->t('Import batch size'),
      '#description' => $this->t('The number of objects imported in each batch process.'),
      '#default_value' => $config->get('import_batch_size') ?: 100,
    ];

    return parent::buildForm($form, $form_state);
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state) {
    parent::submitForm($form, $form_state);

    $this->config('a12s_maps_sync.settings')
      ->set('allowed_entity_types', $form_state->getValue('allowed_entity_types'))
      ->set('ignore_lock', $form_state->getValue('ignore_lock'))
      ->set('import_batch_size', $form_state->getValue('import_batch_size'))
      ->save();
  }

}
