<?php

namespace Drupal\a12s_maps_sync\Maps\Filter;

/**
 * Class AttributeFilter
 */
class AttributeFilter extends \FilterIterator {

  protected $criteria = [];

  /**
   * AttributeFilter constructor.
   *
   * @param \Iterator $iterator
   * @param array $criteria
   */
  public function __construct(\Iterator $iterator, array $criteria) {
    parent::__construct($iterator);
    $this->criteria = $criteria;
  }

  /**
   * {@inheritDoc}
   */
  public function accept(): bool {
    /** @var \Drupal\a12s_maps_sync\Maps\MapsAttribute $attribute */
    $attribute = $this->getInnerIterator()->current();

    foreach ($this->criteria as $name => $criterion) {
      if ($attribute->{$name} !== $criterion) {
        return FALSE;
      }
    }

    return TRUE;
  }

}
