<?php

namespace Drupal\a12s_maps_sync\Maps;

use Drupal\Component\Utility\NestedArray;

/**
 * Class MapsAttribute
 */
class MapsAttribute implements MapsAttributeInterface {

  protected $name;

  protected $objectId;

  protected $profile;

  protected $converter;

  protected $code;

  protected $values;

  protected $data;


  /**
   * Constructs a new MapsAttribute object.
   *
   * @param array $data
   *   The initial attribute data.
   */
  public function __construct(array $data) {
    $this->name = $data['name'];
    $this->objectId = $data['object_id'] ?? NULL;
    $this->profile = $data['profile'];
    $this->converter = $data['converter'] ?? NULL;
    $this->code = $data['code'];

    $extra_data = @json_decode($data['data'], TRUE) ?: [];
    // @todo how to handle sequence?
    $this->setValue($data['value'], $data['language'], $data['delta'], $extra_data);
  }

  /**
   * Set value for a specific delta.
   *
   * @param $value
   * @param int $delta
   * @param int $language_id
   * @param array $data
   *
   * @return \Drupal\a12s_maps_sync\Maps\MapsAttribute
   */
  public function setValue($value, int $language_id, int $delta = 0, array $data = []): MapsAttribute {
    // @todo how to handle sequence?
    $this->values[$delta][$language_id] = ['value' => $value] + $data;
    return $this;
  }

  /**
   * {@inheritdoc}
   */
  public function getValue(int $language_id, int $delta = 0, array $parents = ['value']) {
    array_unshift($parents, $delta, $language_id);
    return NestedArray::getValue($this->values, $parents);
  }

  /**
   * {@inheritdoc}
   */
  public function getCountValue(): int {
    return count($this->values);
  }

  /**
   * {@inheritdoc}
   */
  public function __get(string $name) {
    $properties = ['name', 'object_id', 'profile', 'code', 'values'];

    if (in_array($name, $properties)) {
      return $this->{$name};
    }
  }

}
