<?php

namespace Drupal\a12s_maps_sync\Maps;

/**
 * Interface MapsAttributeInterface
 */
interface MapsAttributeInterface {

  /**
   * Magic method: Gets an attribute property.
   *
   * @param string $name
   *   The name of the property data to get; e.g., 'name' or 'code'.
   *
   * @return mixed
   *   The attribute property.
   */
  public function __get(string $name);

  /**
   * Get an attribute value or extra data.
   *
   * @param int $language_id
   * @param int $delta
   * @param array $parents
   *
   * @return mixed
   */
  public function getValue(int $language_id, int $delta = 0, array $parents = []);

  /**
   * Get the count of values for the attribute.
   *
   * @return int
   */
  public function getCountValue(): int;

}
