<?php

namespace Drupal\a12s_maps_sync\Maps;

use Drupal\a12s_maps_sync\Maps\Filter\AttributeFilter;

class MapsBase implements MapsBaseInterface {

  /**
   * The MaPS System ID.
   *
   * @var int
   */
  protected $id;

  /**
   * The source profile name.
   *
   * @var string
   */
  protected $profile;

  /**
   * The source converter name.
   *
   * @var string
   */
  protected $converter;

  /**
   * The object attributes.
   *
   * @var \Drupal\a12s_maps_sync\Maps\MapsAttribute[]
   */
  protected $attributes;

  /**
   * Constructs a new MapsObject object.
   */
  public function __construct() {
    $this->attributes = new \ArrayObject();
  }


  /**
   * {@inheritdoc}
   */
  public function getId(): int {
    return $this->id;
  }

  /**
   * {@inheritdoc}
   */
  public function setId(int $id): MapsBase {
    $this->id = $id;
    return $this;
  }

  /**
   * {@inheritdoc}
   */
  public function getProfile(): string {
    return $this->profile;
  }

  /**
   * {@inheritdoc}
   */
  public function setProfile(string $profile): MapsBase {
    $this->profile = $profile;
    return $this;
  }

  /**
   * {@inheritdoc}
   */
  public function getConverter(): string {
    return $this->converter;
  }

  /**
   * {@inheritdoc}
   */
  public function setConverter(string $converter): MapsBase {
    $this->converter = $converter;
    return $this;
  }

  /**
   * {@inheritDoc}
   */
  public function filterAttributes(array $criteria): AttributeFilter {
    return new AttributeFilter($this->attributes->getIterator(), $criteria);
  }

  /**
   * {@inheritDoc}
   * @todo merge with "get" method ?
   */
  public function getCountValues(string $name): int {
    $parts = explode('][', $name);
    $first = array_shift($parts);

    if ($first === 'attribute' && ($second = array_shift($parts))) {
      parse_str($second, $criteria);
      $attributes = $this->filterAttributes($criteria);

      $third = array_shift($parts) ?? 'current';
      $attribute = NULL;

      foreach ($attributes as $attribute) {
        if ($third === 'current') {
          break;
        }
      }

      if (isset($attribute)) {
        return $attribute->getCountValue();
      }
    }

    return 0;
  }

  /**
   * {@inheritDoc}
   */
  public function get(string $name, int $language_id = NULL, $delta = NULL) {
    $parts = explode('][', $name);
    $first = array_shift($parts);

    // attribute][name=MYNAME&code=MYCODE][current][0][value
    if ($first === 'attribute' && ($second = array_shift($parts))) {
      parse_str($second, $criteria);
      $attributes = $this->filterAttributes($criteria);

      // @todo handle index number and implode.
      $third = array_shift($parts) ?? 'current';
      $attribute = NULL;

      foreach ($attributes as $attribute) {
        if ($third === 'current') {
          break;
        }
      }

      if (isset($attribute)) {
        $fourth = array_shift($parts) ?? '0';
        $fifth = array_shift($parts) ?? 'value';

        if ($delta === NULL) {
          $delta = (int) $fourth;
        }

        return $attribute->getValue($language_id, $delta, explode('&', $fifth));
      }
    }
  }

  /**
   * {@inheritDoc}
   */
  public function setAttributes(array $attributes): MapsBaseInterface {
    $this->attributes->exchangeArray($attributes);
    return $this;
  }

}
