<?php

namespace Drupal\a12s_maps_sync\Maps;

use Drupal\a12s_maps_sync\Maps\Filter\AttributeFilter;

interface MapsBaseInterface {

  /**
   * The machine name of the field that stores the global identifier for a
   * MaPS Object.
   */
  const GID_FIELD = 'a12s_maps_sync_gid';

  /**
   * Get an object property, attribute related data or media related data.
   *
   * @param string $name
   *   The data "address".
   * @param int $language_id
   *   The MaPS language id.
   * @param null $delta
   *
   * @return mixed|null
   */
  public function get(string $name, int $language_id = NULL, $delta = NULL);

  /**
   * Get the object ID.
   *
   * @return int
   */
  public function getId(): int;

  /**
   * Set the id.
   *
   * @param $id
   * @return \Drupal\a12s_maps_sync\Maps\MapsBase
   */
  public function setId(int $id): MapsBase;

  /**
   * Get the profile name.
   *
   * @return string
   */
  public function getProfile(): string;

  /**
   * Set the profile name.
   *
   * @param string $profile
   * @return \Drupal\a12s_maps_sync\Maps\MapsBase
   */
  public function setProfile(string $profile): MapsBase;

  /**
   * @return string
   */
  public function getConverter(): string;

  /**
   * @param string $converter
   * @return MapsObject
   */
  public function setConverter(string $converter): MapsBase;

  /**
   * Get the count of values for the given attribute / property.
   *
   * @param string $name
   *   The data "address".
   *
   * @return int
   */
  public function getCountValues(string $name): int;

  /**
   * Get the attributes that match the given criteria.
   *
   * @param array $criteria
   *
   * @return \Drupal\a12s_maps_sync\Maps\Filter\AttributeFilter
   */
  public function filterAttributes(array $criteria) : AttributeFilter;

  /**
   * Set the attributes.
   *
   * @param \Drupal\a12s_maps_sync\Maps\MapsAttribute[] $attributes
   *
   * @return $this
   */
  public function setAttributes(array $attributes): MapsBaseInterface;

}
