<?php

namespace Drupal\a12s_maps_sync\Maps;

class MapsLibrary extends MapsBase implements MapsLibraryInterface {

  /**
   * @var string
   */
  protected $code;

  /**
   * @var int
   */
  protected $id_attribute;

  /**
   * @var int
   */
  protected $id_language;

  /**
   * @var array
   */
  protected $value;

  /**
   * {@inheritdoc}
   */
  public function getCode(): string {
    return $this->code;
  }

  /**
   * {@inheritdoc}
   */
  public function setCode(string $code): MapsLibrary {
    $this->code = $code;
    return $this;
  }

  /**
   * {@inheritdoc}
   */
  public function getIdAttribute(): int {
    return $this->id_attribute;
  }

  /**
   * {@inheritdoc}
   */
  public function setIdAttribute(int $id_attribute): MapsLibrary {
    $this->id_attribute = $id_attribute;
    return $this;
  }

  /**
   * {@inheritdoc}
   */
  public function getIdLanguage(): int {
    return $this->id_language;
  }

  /**
   * {@inheritdoc}
   */
  public function setIdLanguage(int $id_language): MapsLibrary {
    $this->id_language = $id_language;
    return $this;
  }

  /**
   * {@inheritdoc}
   */
  public function getValueByLanguage(int $id_language): ?string {
    return $this->value[$id_language];
  }

  /**
   * {@inheritdoc}
   */
  public function setValueByLanguage(int $id_language, string $value): MapsLibrary {
    $this->value[$id_language] = $value;
    return $this;
  }

  /**
   * {@inheritdoc}
   */
  public function getValue(int $id_language = NULL) {
    if ($id_language !== NULL) {
      return $this->getValueByLanguage($id_language);
    }
    return $this->value;
  }

  /**
   * {@inheritdoc}
   */
  public function setValue(array $value): MapsLibrary {
    $this->value = $value;
    return $this;
  }

  /**
   * {@inheritDoc}
   */
  public function get(string $name, int $language_id = NULL, $delta = NULL) {
    $properties = [
      'id',
      'profile',
      'converter',
      'code',
      'id_attribute',
      'id_language',
    ];

    if (in_array($name, $properties)) {
      return $this->{$name};
    }

    if ($name === 'value') {
      return $this->getValue($language_id);
    }
  }
}
