<?php

namespace Drupal\a12s_maps_sync\Maps;

interface MapsLibraryInterface extends MapsBaseInterface {

  /**
   * @return string
   */
  public function getCode(): string;

  /**
   * @param string $code
   * @return MapsLibrary
   */
  public function setCode(string $code): MapsLibrary;

  /**
   * @return int
   */
  public function getIdAttribute(): int;

  /**
   * @param int $id_attribute
   * @return MapsLibrary
   */
  public function setIdAttribute(int $id_attribute): MapsLibrary;

  /**
   * @return int
   */
  public function getIdLanguage(): int;

  /**
   * @param int $id_language
   * @return MapsLibrary
   */
  public function setIdLanguage(int $id_language): MapsLibrary;

  /**
   * @param int|null $id_language
   * @return mixed array|string
   *   If an id language is provided, we return the value for the given language.
   *   Else, we return values for all languages
   */
  public function getValue(int $id_language = NULL);

  /**
   * @param array $value
   * @return MapsLibrary
   */
  public function setValue(array $value): MapsLibrary;

  /**
   * {@inheritdoc}
   */
  public function getValueByLanguage(int $id_language): ?string;

  /**
   * {@inheritdoc}
   */
  public function setValueByLanguage(int $id_language, string $value): MapsLibrary;

}
