<?php

namespace Drupal\a12s_maps_sync\Maps;

use Drupal\Core\Entity\Query\QueryInterface;

class MapsMedia extends MapsBase implements MapsMediaInterface {

  /**
   * The media extension.
   *
   * @var string
   */
  protected $extension;

  /**
   * The MaPS type id.
   *
   * @var int
   */
  protected $type;

  /**
   * The MaPS Url for the media.
   *
   * @var string
   */
  protected $url;

  /**
   * The media weight.
   *
   * @var int
   */
  protected $weight;

  /**
   * The file name.
   *
   * @var string
   */
  protected $filename;

  /**
   * {@inheritdoc}
   */
  public function getExtension(): string {
    return $this->extension;
  }

  /**
   * {@inheritdoc}
   */
  public function setExtension(string $extension): MapsMedia {
    $this->extension = $extension;
    return $this;
  }

  /**
   * {@inheritdoc}
   */
  public function getType(): int {
    return $this->type;
  }

  /**
   * {@inheritdoc}
   */
  public function setType(int $type): MapsMedia {
    $this->type = $type;
    return $this;
  }

  /**
   * {@inheritdoc}
   */
  public function getUrl(): string {
    return $this->url;
  }

  /**
   * {@inheritdoc}
   */
  public function setUrl(string $url): MapsMedia {
    $this->url = $url;
    return $this;
  }

  /**
   * {@inheritdoc}
   */
  public function getWeight(): int {
    return $this->weight;
  }

  /**
   * {@inheritdoc}
   */
  public function setWeight(int $weight): MapsMedia {
    $this->weight = $weight;
    return $this;
  }

  /**
   * {@inheritdoc}
   */
  public function getFilename(): string {
    return $this->filename;
  }

  /**
   * {@inheritdoc}
   */
  public function setFilename(string $filename): MapsMedia {
    $this->filename = $filename;
    return $this;
  }

  /**
   * {@inheritdoc}
   */
  public function get(string $name, int $language_id = NULL, $delta = NULL) {
    $properties = ['id', 'profile', 'converter', 'type', 'extension', 'url', 'weight', 'filename'];

    if (in_array($name, $properties, TRUE)) {
      return $this->{$name};
    }

    if ($language_id === NULL) {
      // @todo Default value ?
      $language_id = 2;
    }

    return parent::get($name, $language_id, $delta);
  }

}
