<?php

namespace Drupal\a12s_maps_sync\Maps;

use Drupal\a12s_maps_sync\Entity\MapsSyncProfile;

/**
 * Class MapsObject
 */
class MapsObject extends MapsBase implements MapsObjectInterface {

  /**
   * The parent object ID.
   *
   * @var int
   */
  protected $parent_id;

  /**
   * The source object ID.
   *
   * @var int
   */
  protected $source_id;

  /**
   * The object code.
   *
   * @var string
   */
  protected $code;

  /**
   * The object nature.
   *
   * @var int
   */
  protected $nature;

  /**
   * The object type.
   *
   * @var int
   */
  protected $type;

  /**
   * The object status.
   *
   * @var int
   */
  protected $status;

  /**
   * The object sequence.
   *
   * @var int
   */
  protected $sequence;

  /**
   * The object configuration type.
   *
   * @var string
   */
  protected $config_type;

  /**
   * The object medias.
   *
   * @var array
   */
  protected $medias = [];

  /**
   * {@inheritDoc}
   */
  public function get(string $name, int $language_id = NULL, $delta = NULL) {
    $properties = ['id', 'profile', 'converter', 'parent_id', 'source_id', 'code', 'nature', 'type', 'status', 'sequence', 'config_type', 'medias'];

    if (in_array($name, $properties)) {
      return $this->{$name};
    }

    if ($language_id === NULL) {
      $profile = MapsSyncProfile::load($this->getProfile());
      $language_id = $profile->getDefaultMapsLanguage();
    }

    return parent::get($name, $language_id, $delta);
  }

  /**
   * {@inheritDoc}
   */
  public function getId(): int {
    return $this->id;
  }

  /**
   * {@inheritDoc}
   */
  public function getProfile(): string {
    return $this->profile;
  }

  /**
   * {@inheritdoc}
   */
  public function getConverter(): string {
    return $this->converter;
  }

  /**
   * {@inheritdoc}
   */
  public function setConverter(string $converter): MapsBase {
    $this->converter = $converter;
    return $this;
  }

  /**
   * {@inheritDoc}
   */
  public function getParentId(): int {
    return $this->parent_id;
  }

  /**
   * {@inheritDoc}
   */
  public function getSourceId(): int {
    return $this->source_id;
  }

  /**
   * {@inheritDoc}
   */
  public function getCode(): string {
    return $this->code;
  }

  /**
   * {@inheritDoc}
   */
  public function getNatureId(): int {
    return $this->nature;
  }

  /**
   * {@inheritDoc}
   */
  public function getTypeId(): int {
    return $this->type;
  }

  /**
   * {@inheritDoc}
   */
  public function getStatusId(): int {
    return $this->status;
  }

  /**
   * {@inheritDoc}
   */
  public function getSequence(): int {
    return $this->sequence;
  }

  /**
   * {@inheritDoc}
   */
  public function getConfigType(): string {
    return $this->config_type;
  }

  /**
   * {@inheritDoc}
   */
  public function getMedias(): array {
    return $this->medias;
  }

  /**
   * {@inheritDoc}
   */
  public function setMedias(array $medias): MapsObjectInterface {
    $this->medias = $medias;
    return $this;
  }

  /**
   * {@inheritDoc}
   */
  public function getCountValues(string $name): int {
    $properties = ['id', 'profile', 'parent_id', 'source_id', 'code', 'nature', 'type', 'status', 'sequence', 'config_type'];
    if (in_array($name, $properties)) {
      return 1;
    }

    return parent::getCountValues($name);
  }


}
