<?php

namespace Drupal\a12s_maps_sync\Maps;

/**
 * Interface MapsObjectInterface
 */
interface MapsObjectInterface extends MapsBaseInterface {

  /**
   * Get the parent object ID.
   *
   * @return int
   */
  public function getParentId(): int;

  /**
   * Get the source object ID.
   *
   * @return int
   */
  public function getSourceId(): int;

  /**
   * Get the object code.
   *
   * @return string
   */
  public function getCode(): string;

  /**
   * Get the nature ID.
   *
   * @return int
   */
  public function getNatureId(): int;

  /**
   * Get the type ID.
   *
   * @return int
   */
  public function getTypeId(): int;

  /**
   * Get the status ID.
   *
   * @return int
   */
  public function getStatusId(): int;

  /**
   * Get the sequence.
   *
   * @return int
   */
  public function getSequence(): int;

  /**
   * get the configuration type.
   *
   * @return string|null
   */
  public function getConfigType(): ?string;

  /**
   * @return array
   */
  public function getMedias(): array;

  /**
   * @param array $medias
   * @return \Drupal\a12s_maps_sync\Maps\MapsObjectInterface
   */
  public function setMedias(array $medias): MapsObjectInterface;

}
