<?php

namespace Drupal\a12s_maps_sync;

use Drupal\Core\Entity\EntityTypeInterface;
use Drupal\Core\Entity\Routing\AdminHtmlRouteProvider;
use Symfony\Component\Routing\Route;

/**
 * Provides routes for Maps sync converter entities.
 *
 * @see Drupal\Core\Entity\Routing\AdminHtmlRouteProvider
 * @see Drupal\Core\Entity\Routing\DefaultHtmlRouteProvider
 */
class MapsSyncConverterHtmlRouteProvider extends AdminHtmlRouteProvider {

  /**
   * Add profile required information for the route converter.
   *
   * @param \Symfony\Component\Routing\Route $route
   */
  protected function addProfileParameterToRoute(Route $route): void {
    $parameters = $route->getOption('parameters');
    $parameters['maps_sync_profile']['type'] = 'entity:maps_sync_profile';
    $route->setOption('parameters', $parameters);
  }

  /**
   * {@inheritdoc}
   */
  protected function getAddPageRoute(EntityTypeInterface $entity_type) {
    if ($route = parent::getAddPageRoute($entity_type)) {
      $this->addProfileParameterToRoute($route);
      return $route;
    }
  }

  /**
   * {@inheritdoc}
   */
  protected function getAddFormRoute(EntityTypeInterface $entity_type) {
    if ($route = parent::getAddFormRoute($entity_type)) {
      $this->addProfileParameterToRoute($route);
      return $route;
    }
  }

  /**
   * {@inheritdoc}
   */
  protected function getEditFormRoute(EntityTypeInterface $entity_type) {
    if ($route = parent::getEditFormRoute($entity_type)) {
      $this->addProfileParameterToRoute($route);
      return $route;
    }
  }

  /**
   * {@inheritdoc}
   */
  protected function getDeleteFormRoute(EntityTypeInterface $entity_type) {
    if ($route = parent::getDeleteFormRoute($entity_type)) {
      $this->addProfileParameterToRoute($route);
      return $route;
    }
  }

  /**
   * {@inheritdoc}
   */
  protected function getCanonicalRoute(EntityTypeInterface $entity_type) {
    if ($route = parent::getCanonicalRoute($entity_type)) {
      $this->addProfileParameterToRoute($route);
      return $route;
    }
  }

  /**
   * {@inheritdoc}
   */
  protected function getCollectionRoute(EntityTypeInterface $entity_type) {
    if ($route = parent::getCollectionRoute($entity_type)) {
      $this->addProfileParameterToRoute($route);
      return $route;
    }
  }

}
