<?php

namespace Drupal\a12s_maps_sync;

use Drupal\Core\Config\Entity\DraggableListBuilder;
use Drupal\Core\Entity\EntityInterface;

/**
 * Provides a listing of Maps sync converter entities.
 */
class MapsSyncConverterListBuilder extends DraggableListBuilder {

  protected $weightKey = 'weight';

  /**
   * {@inheritdoc}
   */
  protected function getTitle() {
    $profile = \Drupal::request()->get('maps_sync_profile');
    return $this->t('Converters for profile @profile', ['@profile' => $profile->label()]);
  }

  /**
   * {@inheritdoc}
   */
  public function buildHeader() {
    $header['label'] = $this->t('Maps sync converter');
    return $header + parent::buildHeader();
  }

  /**
   * {@inheritdoc}
   */
  public function buildRow(EntityInterface $entity) {
    /** @var \Drupal\a12s_maps_sync\Entity\MapsSyncConverterInterface $entity */
    $row['label'] = $entity->label();
    return $row + parent::buildRow($entity);
  }

  /**
   * {@inheritdoc}
   */
  public function getFormId() {
    return 'maps_sync_converter.list_builder';
  }

  /**
   * {@inheritdoc}
   */
  protected function getEntityIds() {
    $request = \Drupal::request();
    $profile = $request->get('maps_sync_profile');

    if (!$profile) {
      throw new \InvalidArgumentException("Missing profile.");
    }

    $query = $this->getStorage()->getQuery()
      ->condition('profile_id', $profile->id())
      ->sort($this->entityType->getKey('id'));

    return $query->execute();
  }

}
