<?php

namespace Drupal\a12s_maps_sync;

use Drupal\Core\Config\Entity\ConfigEntityListBuilder;
use Drupal\Core\Entity\EntityInterface;
use Drupal\Core\Url;

/**
 * Provides a listing of MaPS Sync profile entities.
 */
class MapsSyncProfileListBuilder extends ConfigEntityListBuilder {

  /**
   * {@inheritdoc}
   */
  public function buildHeader() {
    $header['label'] = $this->t('MaPS Sync profile');
    $header['id'] = $this->t('Machine name');
    return $header + parent::buildHeader();
  }

  /**
   * {@inheritdoc}
   */
  public function buildRow(EntityInterface $entity) {
    $row['label'] = $entity->label();
    $row['id'] = $entity->id();
    // You probably want a few more properties here...
    return $row + parent::buildRow($entity);
  }

  /**
   * {@inheritdoc}
   */
  public function getOperations(EntityInterface $entity) {
    $operations = parent::getOperations($entity);

    // Add the converter collection link.
    $operations['converters'] = [
      'title' => $this->t('Converters'),
      'weight' => -40,
      'url' => Url::fromRoute('entity.maps_sync_converter.collection', ['maps_sync_profile' => $entity->id()]),
    ];

    return $operations;
  }

}
