<?php

namespace Drupal\ab_paragraphs\Form;

use Drupal\Core\Form\ConfigFormBase;
use Drupal\Core\Form\FormStateInterface;

/**
 * Configureer de instellingen voor A/B Paragraphs.
 */
class FinalistAbParagraphsSettingsForm extends ConfigFormBase {

  /**
   * {@inheritdoc}
   */
  public function getFormId() {
    return 'ab_paragraphs_settings_form';
  }

  /**
   * {@inheritdoc}
   */
  protected function getEditableConfigNames() {
    return ['ab_paragraphs.settings'];
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state) {
    $config = $this->config('ab_paragraphs.settings');

    $form['analytics_provider'] = [
      '#type' => 'radios',
      '#title' => $this->t('Select Analytics Provider'),
      '#description' => $this->t('Kies welke analytics provider-suggesties gegeven moeten worden.'),
      '#options' => [
        'matomo' => $this->t('Matomo'),
        'google_analytics' => $this->t('Google Analytics'),
      ],
      '#default_value' => $config->get('analytics_provider') ?: 'matomo',
    ];

    return parent::buildForm($form, $form_state);
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state) {
    $this->config('ab_paragraphs.settings')
      ->set('analytics_provider', $form_state->getValue('analytics_provider'))
      ->save();

    parent::submitForm($form, $form_state);
  }
}
