(function ($, Drupal, once) {
  /**
   * Check if analytics consent is given via one of known systems.
   */
  function hasAnalyticsConsent() {
    // Cookiebot
    if (typeof Cookiebot !== 'undefined') {
      return Cookiebot.consents && Cookiebot.consents.given && Cookiebot.consents.statistics;
    }

    // Klaro!
    if (typeof Klaro !== 'undefined') {
      return Klaro.getManager && Klaro.getManager().consent?.analytics === true;
    }

    // CookieConsent v3 / Osano / andere
    if (typeof window.CookieConsent !== 'undefined') {
      const cc = window.CookieConsent;
      if (typeof cc.getUserPreferences === 'function') {
        const prefs = cc.getUserPreferences();
        return prefs?.categories?.includes?.('analytics') || prefs?.analytics === true;
      }
    }

    // Own system (editable)
    if (window.myCookieConsent && window.myCookieConsent.analyticsAllowed) {
      return true;
    }

    // System unknown → precaution = no
    // return false;
    // Temporary always true - cookie check probably not needed as this is handled by sitewide cookie consent.
    return true;
  }

  Drupal.behaviors.abTest = {
    attach: function (context, settings) {
      once('ab-test', '.ab-test-wrapper', context).forEach(function (wrapper) {
        const $wrapper = $(wrapper);
        const uuid = $wrapper.data('uuid');
        const distribution = $wrapper.data('distribution') || '50/50';
        const sessionKey = 'ab_variant_' + uuid;

        console.log('✅ A/B script started for:', uuid);

        let variant = sessionStorage.getItem(sessionKey);
        if (!variant) {
          const [a, b] = distribution.split('/').map(Number);
          const rand = Math.random() * 100;
          variant = rand < a ? 'a' : 'b';
          sessionStorage.setItem(sessionKey, variant);
          console.log(`🎲 Distribution: ${a}/${b} → Random: ${rand.toFixed(2)} → Chosen: ${variant.toUpperCase()}`);
        } else {
          console.log(`📦 Variant from session: ${variant.toUpperCase()}`);
        }

        // Hide both variants
        $wrapper.find('.ab-variant-a, .ab-variant-b').addClass('hidden-ab-variant');
        $wrapper.find('.ab-variant-' + variant).removeClass('hidden-ab-variant');

        // Execute tracking code, only if consent for analytics is given
        const tracking= $wrapper.find('.tracking-code-' + variant).text().trim();
        if (hasAnalyticsConsent() && typeof _paq !== 'undefined') {
          try {
            const currentPath = window.location.pathname;
            // Send Show event to analytics.
            _paq.push([
              'trackEvent',
              'A/B Test',                                // Category
              'Show',                                    // Action
              uuid + ' - Variant ' + variant.toUpperCase(), // Label
              1                                          // Event value
            ]);
            console.log('🚀 Execute tracking for variant', variant.toUpperCase());
            eval(tracking);
          } catch (e) {
            console.error('⚠️ Error in trackingcode:', e);
          }
        } else {
          console.log('📉 No analytics consent → trackingcode skipped.');
        }
        // Log shown variant (always).
        console.log('📤 logAbEvent is called');
        const pid = wrapper.dataset.paragraphId;
        // Logging function + page not yet built. Probably to be removed / no use.
        // logAbEvent(variant, uuid, pid, tracking);
      });
    }
  };

  /**
   * Log events of variants shown.
   */
  function logAbEvent(variant, uuid, pid, tracking) {
    fetch('/ab/log', {
      method: 'POST',
      body: JSON.stringify({
        variant: variant,
        uuid: uuid,
        paragraph_id: pid,
        tracking: tracking
      }),
      headers: {
        'Content-Type': 'application/json'
      }
    });
  }
})(jQuery, Drupal, once);
