# A/B Paragraphs

This module adds a new Paragraph type called `A/B Test`.

## Features

- A/B test paragraph with Variant A and Variant B
- Individual tracking code fields for each variant
- Unique ID + distribution ratio (e.g. 50/50, 90/10)
- Session-based frontend rendering (JavaScript-driven)
- Only one variant is shown per user session

## After installation

### ✅ Automatically handled:
- Paragraph type `ab_test` is created
- Fields are added:
  - `field_variant_a`
  - `field_variant_b`
  - `field_tracking_code_a`
  - `field_tracking_code_b`
  - `field_unique_id`
  - `field_distribution`

### ⚠️ Manual steps required:

You need to manually enable all fields in both the **form display** and the **view display** for the A/B Test paragraph type:

- Go to: `/admin/structure/paragraphs_type/ab_test/form-display`
- And: `/admin/structure/paragraphs_type/ab_test/display`

Ensure that:

- `field_tracking_code_a` and `field_tracking_code_b` use the **Plain text (multiple lines)** field type (not formatted text).
- All fields are visible and editable.

## Consent & Tracking

Tracking code is only executed **after the user has given consent for analytics**.

This works out of the box with popular cookie consent tools such as:
- Cookiebot
- Klaro
- Osano
- CookieYes
- Custom implementations

Tracking code is inserted via a plain `<script type="text/plain">` element and executed conditionally in JavaScript.
