<?php

namespace Drupal\ab_paragraphs\Controller;

use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\Request;
use Drupal\Core\Controller\ControllerBase;

/**
 * Logs A/B variant events.
 */
class AbLogController extends ControllerBase {

  public function log(Request $request) {
    $data = json_decode($request->getContent(), TRUE);

    if (!empty($data['variant']) && !empty($data['uuid']) && !empty($data['paragraph_id'])) {
      \Drupal::logger('ab_paragraphs')->notice('A/B variant shown: @variant | Paragraph ID: @pid | Unique ID: @uuid | Tracking: @tracking', [
        '@variant' => $data['variant'],
        '@pid' => $data['paragraph_id'],
        '@uuid' => $data['uuid'],
        '@tracking' => $data['tracking'] ?? '-',
      ]);

      return new JsonResponse(['status' => 'ok']);
    }

    return new JsonResponse(['status' => 'error'], 400);
  }
}
