*ABC theme for Drupal 8, 9 and 10.*
=================================
Thank you for downloading this theme!


ABOUT THE ABC THEME:
===========================

**ABC** is an advanced responsive, mobile first, HTML5 theme with layout and style configuration options built in that you can control through Drupal's UI. The theme is a highly customized and complex theme that goes beyond the basic customization options provided by Drupal. It uses [Yahoo Pure.css](https://purecss.io), a powerful responsive CSS framework and also fully supports right to left languages. Pure is ridiculously tiny. The entire set of modules clocks in at 3.5KB minified and gzipped.

The theme **validates HTML5 and CSS3**, it is cross-browser compatible, and it complies with [WAVE](https://wave.webaim.org/) and [FAE](https://fae.cita.uiuc.edu/).


Theme's features
----------------------------------------

- 1, 2, or 3 column layout with customizable widths using [Yahoo Pure.css Framework](https://purecss.io);
- 16 block regions;
- Many color options for: logo, background, titles, blocks, menu items + custom settings. Further   customization can be made by choosing "custom" for different settings and then make appropriate modifications of /_custom/custom-style.css;
- **Helpful body classes** (unique classes for each page, term, website section, etc.);
- Themed blocks, block icons, page icons;
- Drop-down Main menu;
- Primary/secondary links menu position (center, left, right);
- Three font families;
- Different font sizes;
- Round corners for page elements and menus;
- Header image rotator;
- Full breadcrumb;
- No-followed login/register links;
- Duplicate the Main Menu in the footer of the page.
- Possibility to **change "Submitted by" display**;
- **Advanced SEO optimization**;
- Theme's own slideshow with Multilingual support. It now features two distinct variations, each comprising 7 slides: one showcasing full-page images and the other displaying half-page images.
- Social links integration;
- **Bi-directional right to left (RTL) theming**;
- The possibility of having different logos depending on the language;
- Works perfect in Multilingual installations.


Advanced theme settings features
----------------------------------------

### Pure.CSS settings

- Responsive CSS files served from Yahoo CDN or locally;
- Layout with fixed or fluid width;
- Customizable width for First and Second sidebars;
- Feature to choose the blocks visible on mobile devices.


### Layout settings

- Latin alphabet logos in 5 colors;
- Layout width - adaptive, fixed and fluid width with responsive layouts for mobile devices;
- Background settings - background image, 5 colors, with static or fixed position;
- Site name and node title in 5 colors;
- Block settings - 6 Title color settings, and themed blocks for sidebars and user regions;
- Built in multi-level drop-down menu, left, center or right positioned;
- Duplicate the Main Menu at the bottom of the page;
- Menu items in 9 colors, including different colors for the first and last items;
- Tertiary menu built in; 
- Three font families (Sans-Serif, Montserrat and Merriweather);
- Three font size settings;
- Themed blocks;
- Block icons for the themed blocks;
- Main Drop-down menu and secondary menu can be positioned (center, left, right);
- Three options for Search submit: button, icon or none;
- Page icons - choose a layout with or without page icons;
- Rounded corners for page elements and menus;
- Header image rotator;
- Duplicate the Main Menu at the bottom of the page.


### Other settings

- Breadcrumbs - display or not;
- Ability to change author and date information on all node types or differently for blog posts and forum topics;
- Replace "Submitted by" with other text;
- SEO optimization;
- Slideshow;
- Social Media Links at the bottom of the page;
- Remove Drupal META tag & Drupal X-Generator from header;
- Disable cache for all blocks;
- Site ID body class - useful in a multi-site environment.
- Show Logo per language.


To know more, read [the handbook](https://drupal.org/node/507792).


Module support
----------------------------------------

The theme can support virtualy any module.
This versatile, **base theme** stands alone, free from dependence on other modules or libraries.

  
Theme customisation
----------------------------------------

If you feel like giving the theme a look of your own, I recommend to play with /_custom/custom-style.css; please read the comments in this file.

#### Font Awesome
First, you must install [Font Awesome Icons](https://www.drupal.org/project/fontawesome) and enable "Font Awesome" in the theme settings.
To use Font Awesome in the Main Navigation, add the appropriate class to the menu title. For example, use fa fa-home for "Home" or fa fa-envelope for "Contact."

The Main Navigation examples provided are for reference. For a complete list of available Font Awesome icons, visit the [Font Awesome documentation] (https://docs.fontawesome.com/).

#### Slideshow
At www.dr.mt, you'll find a compilation of pre-optimized images for your slideshow. Feel free to download them from this source, where the images are organized into sections.


Installation instructions
----------------------------------------

1. Place the abc directory into your themes directory (/themes/abc) or use Composer. If using Composer, the theme will be installed at  /themes/contrib/abc.
2. Enable the ABC theme (/admin/appearance).
3. Proceed to the theme's settings by navigating to /admin/appearance/settings/abc and ensure to save the configuration. Note that some of the theme's settings are multilingual variables, allowing you to configure different settings for each language.
4. Within the themes' directory, locate the "_custom" folder and rename 'example.custom-style.css' to 'custom-style.css'. This file, 'custom-style.css', provides extensive customization options and may contain your custom CSS and CSS overrides. Please read the info of this file.


UPGRADING to a new version of ABC
----------------------------------------

1. Log in as administrator user. 
2. Put the site in "Off-line" mode.
3. Place the abc directory into your themes directory (/themes/abc) or use Composer. In case you have done some theme customization, remember to overwrite theme's custom-style.css with your modified custom-style.css file.
4. Clear cached data at /admin/config/development/performance or "Flush all caches" in Admin Menu and then press CTRL+F5;
5. Put the site in "On-line" mode. It is always a good idea to refresh the browser's cache again.
6. Check the theme's settings at /admin/appearance/settings/abc. 


Resources
----------------------------------------

- [Yahoo Pure.css Framework](https://purecss.io)
- [Github Project Page](https://github.com/yui/pure/)
- [Pure skin builder](https://yui.github.io/skinbuilder/?mode=pure)


Sites using "ABC" theme
----------------------------------------

Various implementations of the ABC theme can be found here:
- [Demo/test site](https://www.softchannels.com/)
- [Dr. Radut Web Solutions](https://www.dr.mt/)


Related themes
----------------------------------------

- [Zero Point](https://www.drupal.org/project/zeropoint) - a very customizable HTML5 theme;
- [Black Hole](https://www.drupal.org/project/black_hole) - a dark HTML5 theme.
- [Yahoo Pure.CSS Framework](https://www.drupal.org/project/pure_css) - an advanced responsive, mobile-first, HTML5, base-theme.


Contact
----------------------------------------

My Drupal nick is [Florian](https://www.drupal.org/u/florian) and I can be reached at florian@radut.net (https://www.radut.com).

I can also be contacted for paid customizations of the theme as well as Drupal consulting, installation and customizations.
