<?php

namespace Drupal\abuseipdb\Form;

use Drupal\Core\Form\ConfigFormBase;
use Drupal\Core\Form\FormStateInterface;

/**
 * Module settings.
 */
class Settings extends ConfigFormBase {

  /**
   * {@inheritdoc}
   */
  public function getFormId() {
    return 'abuseipdb_settings_form';
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state) {
    // Form Constructor.
    $form = parent::buildForm($form, $form_state);
    // Default Settings.
    $config = $this->config('abuseipdb.settings');
    // Api Key field.
    $form['api_key'] = [
      '#type' => 'textfield',
      '#title' => $this->t('AbuseIPDB Api Key:'),
      '#default_value' => $config->get('abuseipdb.api_key'),
      '#description' => $this->t('Your AbuseIPDB account which will be linked to the reports delivered to the database'),
    ];

    $form['abuse_confidence_score'] = [
      '#type' => 'number',
      '#title' => $this->t('Abuse Confidence Score'),
      '#description' => $this->t(
        'The minimum score at which you want to begin banning IPs.
        The Abuse Confidence Score is a 0-100 scale of abusiveness where 0 is
        no abuse and 100 is very abusive.
        <a target="_blank" href="https://docs.abuseipdb.com/?php#blacklist-endpoint">
        AbuseIPDB recommends a value between 75 and 100</a>. <strong>WARNING</strong>
        A value of 0 will ban <u>every</u> IP address.'
      ),
      '#default_value' => $config->get('abuseipdb.abuse_confidence_score'),
      '#min' => 0,
      '#max' => 100,
    ];

    $form['shutdown'] = [
      '#type' => 'checkbox',
      '#title' => $this->t('Emergency shutdown'),
      '#default_value' => $config->get('abuseipdb.shutdown'),
      '#description' => $this->t('Disable checks and reports.'),
    ];

    return $form;
  }

  /**
   * {@inheritdoc}
   */
  public function validateForm(array &$form, FormStateInterface $form_state) {

  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state) {
    $this->configFactory->getEditable('abuseipdb.settings')
      ->set('abuseipdb.api_key', $form_state->getValue('api_key'))
      ->set('abuseipdb.shutdown', $form_state->getValue('shutdown'))
      ->set('abuseipdb.abuse_confidence_score', $form_state->getValue('abuse_confidence_score'))
      ->save();
    return parent::submitForm($form, $form_state);
  }

  /**
   * {@inheritdoc}
   */
  protected function getEditableConfigNames() {
    return [
      'abuseipdb.settings',
    ];
  }

}
