<?php

namespace Drupal\abuseipdb\Form;

use Drupal\Core\Form\ConfigFormBase;
use Drupal\Core\Form\FormStateInterface;

/**
 * The form which lists ips that should be whitelisted.
 */
class IpWhiteList extends ConfigFormBase {

  /**
   * {@inheritdoc}
   */
  public function getFormId() {
    return 'abuseipdb_whitelist_form';
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state) {
    // Form Constructor.
    $form = parent::buildForm($form, $form_state);
    // Default Settings.
    $config = $this->config('abuseipdb.settings');
    $form['instructions'] = [
      '#type' => 'item',
      '#markup' => $this->t('
        <p>This is a list of IPs that should not be checked or banned.</p>
        <p>Use carefully! Only add IPs and/or IP ranges that you fully trust. This will bypass all IP checks.</p>
      '),
    ];

    // List ips.
    $form['whitelist'] = [
      '#type' => 'textarea',
      '#title' => $this->t('IPs Whitelist'),
      '#default_value' => $config->get('abuseipdb.whitelist'),
      '#description' => $this->t('List of IPs that will not be checked or banned. Please add one per line. You can add a normal IP 0.0.0.0 or you can add an IP range 0.0.0.0/24 (CIDR).'),
      '#required' => FALSE,
    ];
    return $form;
  }

  /**
   * {@inheritdoc}
   */
  public function validateForm(array &$form, FormStateInterface $form_state) {
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state) {
    $this->configFactory->getEditable('abuseipdb.settings')
      ->set('abuseipdb.whitelist', $form_state->getValue('whitelist'))
      ->save();
    return parent::submitForm($form, $form_state);
  }

  /**
   * {@inheritdoc}
   */
  protected function getEditableConfigNames() {
    return [
      'abuseipdb.settings',
    ];
  }

}
