## INTRODUCTION

The abusive traffic module helps identify abusive traffic (aka spam users) by IP address. The module will send an email to you so you can review if they are actually spam, or not. You should then block them via the ban module or a .htaccess rule (better option).

The module has drush commands which leverages the Acquia Cloud API (v2) to:

- Identifiy the application_uuid (to save to secrets)
- Generate an Apache Access log file of the last 1 hour
- Download and parse the Apache Access log file
    - An email will be sent if the number of hits is greater than the threshold value you set.

### WARNING
In a perfert world, you would have a WAF and a CDN to help be proactive with spammers. That isn't always the case, so that is why this module exists.

## REQUIREMENTS

- Acquia Cloud Next hosting.
- phpseclib - https://phpseclib.com

## INSTALLATION

Install as you would normally install a contributed Drupal module.
See: https://www.drupal.org/node/895232 for further information.

You will need to create an Acquia Cloud API Token - https://docs.acquia.com/acquia-cloud-platform/develop-apps/api/auth and save it to a secrets file. See https://docs.acquia.com/secrets#section-secretssettingsphp-file for how to setup the secrets file. Once you have your api key and api secret, save them to the secrets file with these names:

- abusive_traffic_acquia_client_id.key
- abusive_traffic_acquia_client_secret.key

Once you have these two secret settings saved, you need to save the abusive_traffic_acquia_application_uuid.key too. To get a list of all of the application UUIDs that you have access to, run drush abusive_traffic:list-applications. You will see the application name and application UUID output for you to save to the secret settings.

Add phpseclib using composer command:
- composer require phpseclib/phpseclib:~3.0

## CONFIGURATION
Go to /admin/config/system/abusive-traffic and set:

- Threshold of when to send an email (start at 100 to see what you get)
- IP ignorelist - these IPs you have already blocked or know are traffic that is not spam.
- Email list - comma seperated list of who receives the email when the threshold is crossed.

## SCHEDULED JOBS
The module is meant to have 2 cronjobs (scheduled jobs) to each run every hour. There should be a 5-10 minute gap between the two cronjobs to allow for the Apache Access log file to be generated.

- drush abusive_traffic:generate-log
    - This will generate a log file with logs of the last 1 hour.
- drush abusive_traffic:get-log
    - This will get the latest generated log file, save a copy to the private file directory, and send an email if there is an IP address over the threshold.

## SFTP LOG FILES
If you want to forward the log files, via SFTP, you can do this. Then Splunk, or another service, can parse the log files for you. The drush abusive_traffic:get-log will do this if you have enabled forward log files in the config settings. Make sure to include the following SFTP information in your secrets:

- abusive_traffic_sftp_username.key
- abusive_traffic_sftp_password.key
- abusive_traffic_sftp_server.key
- abusive_traffic_sftp_path.key
    * If you want the files in a folder, you will need to create the folder on the server.

## BLOCKING ABUSIVE TRAFFIC IPS
If you find IP addresses that are spamming your site, you should ban them using a .htaccess rule - https://docs.acquia.com/acquia-cloud-platform/architecture/security/restrict#section-blocking-by-ip-with-modrewrite-in-htaccess. You can also implement the ban module to block IP addresses without a code deployment, but these users can still cause issues on your site. They might still be counted on your Acquia Views/Visits data. Make sure to deploy updates to your .htacess file to block them for good.

## KNOWN BAD ACTORS
I found out that the 47.76.* IP addresses are known to be bad in a call with an Acquia rep. They are owned from Alibaba and the IP addresses rotate. I suggest banning this range. It's your choice though.

## MAINTAINERS

Current maintainers for Drupal 10:

- Nate Millin - https://www.drupal.org/u/nmillin
