<?php

namespace Drupal\access_by_ref;

use Drupal\Core\Config\Entity\ConfigEntityInterface;

/**
 * Provides an interface defining an Example entity.
 */
interface AbrconfigInterface extends ConfigEntityInterface {

  /**
   * Get the bundle of the abr config.
   *
   * @return string
   *   Name of the bundle.
   */
  public function getBundle();

  /**
   * Set the bundle of the abr config.
   *
   * @param string $bundle
   *   Name of the bundle.
   *
   * @return $this
   */
  public function setBundle($bundle);

  /**
   * Get the field of the abr config.
   *
   * @return string
   *   Name of the field.
   */
  public function getField();

  /**
   * Set the field of the abr config.
   *
   * @param string $field
   *   Name of the field.
   *
   * @return $this
   */
  public function setField($field);

  /**
   * Get the reference type of the abr config.
   *
   * @return string
   *   Name of the reference type.
   */
  public function getReferenceType();

  /**
   * Set the reference type of the abr config.
   *
   * @param string $reference_type
   *   Name of the reference type.
   *
   * @return $this
   */
  public function setReferenceType($reference_type);

  /**
   * Get the extra field of the abr config.
   *
   * @return string
   *   The name of the extra field.
   */
  public function getExtra();

  /**
   * Set the extra field of the abr config.
   *
   * @param string $extra
   *   The name of the extra field.
   *
   * @return $this
   */
  public function setExtra($extra);

  /**
   * Get the rights type of the abr config.
   *
   * @param bool $readable
   *   TRUE if rights type should be returned in human readable form.
   *
   * @return string
   *   The rights type.
   */
  public function getRightsType($readable);

  /**
   * Set the rights type of the abr config.
   *
   * @param string $rights_type
   *   The rights type.
   *
   * @return $this
   */
  public function setRightsType($rights_type);

  /**
   * Get the rights read of the abr config.
   *
   * @return bool
   *   The read access right.
   */
  public function getRightsRead();

  /**
   * Set the rights read of the abr config.
   *
   * @param bool $rights_read
   *   The read access right.
   *
   * @return $this
   */
  public function setRightsRead($rights_read);

  /**
   * Get the rights update of the abr config.
   *
   * @return bool
   *   The update access right.
   */
  public function getRightsUpdate();

  /**
   * Set the rights update of the abr config.
   *
   * @param bool $rights_update
   *   The update access right.
   *
   * @return $this
   */
  public function setRightsUpdate($rights_update);

  /**
   * Get the rights delete of the abr config.
   *
   * @return bool
   *   The delete access right.
   */
  public function getRightsDelete();

  /**
   * Set the rights delete of the abr config.
   *
   * @param bool $rights_delete
   *   The delete access right.
   *
   * @return $this
   */
  public function setRightsDelete($rights_delete);

}
