<?php

namespace Drupal\access_by_ref\Form;

use Drupal\Core\Cache\CacheBackendInterface;
use Drupal\Core\Entity\EntityConfirmFormBase;
use Drupal\Core\Form\FormStateInterface;
use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\Core\Url;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * Builds the form to delete an Example.
 */
class AbrconfigDeleteForm extends EntityConfirmFormBase {

  /**
   * Sets up dependency injection properties.
   *
   * @param \Drupal\Core\Cache\CacheBackendInterface $cacheRenderer
   *   The cache renderer.
   */
  public function __construct(protected CacheBackendInterface $cacheRenderer) {
  }

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container): static {
    return new static(
      $container->get('cache.render')
    );
  }

  /**
   * {@inheritdoc}
   */
  public function getQuestion(): TranslatableMarkup {
    return $this->t('Are you sure you want to delete %name?', ['%name' => $this->entity->label()]);
  }

  /**
   * {@inheritdoc}
   */
  public function getCancelUrl(): Url {
    return new Url('entity.abrconfig.collection');
  }

  /**
   * {@inheritdoc}
   */
  public function getConfirmText(): TranslatableMarkup {
    return $this->t('Delete');
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state): void {
    $this->entity->delete();
    $this->messenger()->addMessage($this->t('Entity %label has been deleted.', ['%label' => $this->entity->label()]));

    // Wipe the Twig PHP Storage cache. ABR needed.
    $this->cacheRenderer->invalidateAll();

    $form_state->setRedirectUrl($this->getCancelUrl());
  }

}
