<?php

namespace Drupal\access_by_ref\Entity;

use Drupal\access_by_ref\AbrconfigInterface;
use Drupal\Core\Config\Entity\ConfigEntityBase;

/**
 * Defines the abrconfig entity.
 *
 * @ConfigEntityType(
 *   id = "abrconfig",
 *   label = @Translation("Abrconfig"),
 *   handlers = {
 *     "list_builder" = "Drupal\access_by_ref\Controller\AbrconfigListBuilder",
 *     "form" = {
 *       "add" = "Drupal\access_by_ref\Form\AbrconfigForm",
 *       "edit" = "Drupal\access_by_ref\Form\AbrconfigForm",
 *       "delete" = "Drupal\access_by_ref\Form\AbrconfigDeleteForm",
 *     }
 *   },
 *   config_prefix = "abrconfig",
 *   admin_permission = "administer access_by_ref_settings settings",
 *   entity_keys = {
 *     "id" = "id",
 *     "label" = "label",
 *     "bundle" = "bundle",
 *     "field" = "field",
 *     "reference_type" = "reference_type",
 *     "extra" = "extra",
 *     "rights_type" = "rights_type",
 *     "rights_read" = "rights_read",
 *     "rights_update" = "rights_update",
 *     "rights_delete" = "rights_delete"
 *   },
 *   config_export = {
 *     "id" = "id",
 *     "label" = "label",
 *     "bundle" = "bundle",
 *     "field" = "field",
 *     "reference_type" = "reference_type",
 *     "extra" = "extra",
 *     "rights_type" = "rights_type",
 *     "rights_read" = "rights_read",
 *     "rights_update" = "rights_update",
 *     "rights_delete" = "rights_delete"
 *   },
 *   links = {
 *     "edit-form" = "/admin/config/content/access_by_ref/{abrconfig}",
 *     "delete-form" = "/admin/config/content/access_by_ref/{abrconfig}/delete",
 *   }
 * )
 */
class Abrconfig extends ConfigEntityBase implements AbrconfigInterface {

  /**
   * The Example ID.
   *
   * @var string
   */
  protected $id;

  /**
   * The Example label.
   *
   * @var string
   */
  protected $label;

  /**
   * The bundle field of the abr config item.
   *
   * @var string
   */
  protected $bundle;

  /**
   * The field of the abr config item.
   *
   * @var string
   */
  protected $field;

  /**
   * The reference type field of the abr config item.
   *
   * @var string
   */
  protected $reference_type;

  /**
   * The extra field of the abr config item.
   *
   * @var string
   */
  protected $extra;

  /**
   * The rights_type field of the abr config item.
   *
   * @var string
   */
  protected $rights_type;

  /**
   * The rights_read field of the abr config item.
   *
   * @var string
   */
  protected $rights_read;

  /**
   * The rights_update field of the abr config item.
   *
   * @var string
   */

  protected $rights_update;

  /**
   * The rights_delete field of the abr config item.
   *
   * @var string
   */
  protected $rights_delete;

  /**
   * Gets the bundle name.
   *
   * @return string
   *   The current bundle name.
   */
  public function getBundle() {
    return $this->get('bundle');
  }

  /**
   * Sets the bundle name.
   *
   * @param string $bundle
   *   The new name of the bundle.
   */
  public function setBundle($bundle) {
    return $this->set('bundle', $bundle);
  }

  /**
   * Gets the field name.
   *
   * @return string
   *   The field name.
   */
  public function getField() {
    return $this->get('field');
  }

  /**
   * Sets the field name.
   *
   * @param string $field
   *   The new value of the field.
   */
  public function setField($field) {
    return $this->set('field', $field);
  }

  /**
   * Gets the reference type.
   *
   * @param bool $readable
   *   If true, return a descriptive version of the reference type.
   *
   * @return string
   *   The reference type.
   */
  public function getReferenceType($readable = FALSE) {

    if ($readable == TRUE) {
      switch ($this->get('reference_type')) {
        case 'user':
          return "User referenced";

        case 'user_mail':
          return "User's mail";

        case 'shared':
          return "Profile value";

        case 'inherit':
          return "Inherit from parent";

        default:
          return $this->get('reference_type');
      }
    }
    else {
      return $this->get('reference_type');
    }

  }

  /**
   * Sets the reference type.
   *
   * @param string $reference_type
   *   The new value of the reference type.
   */
  public function setReferenceType($reference_type) {
    return $this->set('reference_type', $reference_type);
  }

  /**
   * Get the extra field value.
   *
   * @return string
   *   The current value of the extra field.
   */
  public function getExtra() {
    return $this->get('extra');
  }

  /**
   * Set the extra field value.
   *
   * @param string $extra
   *   The new value of the extra field.
   */
  public function setExtra($extra) {
    return $this->set('extra', $extra);
  }

  /**
   * Gets the value of the rights type.
   *
   * @param bool $readable
   *   If true return as a readable string - not currently implemented.
   *
   * @return string
   *   The current rights type.
   */
  public function getRightsType($readable = FALSE) {
    return $this->get('rights_type');
  }

  /**
   * Set the value of the rights type.
   *
   * @param string $rights_type
   *   The new rights type value.
   */
  public function setRightsType($rights_type) {
    return $this->set('rights_type', $rights_type);
  }

  /**
   * Gets the value of the read access right.
   *
   * @return bool
   *   True if user can read the item.
   */
  public function getRightsRead() {
    return $this->get('rights_read');
  }

  /**
   * Sets a new value for the read access right.
   *
   * @param bool $rights_read
   *   If true referenced user will be able to read entity.
   */
  public function setRightsRead($rights_read) {
    return $this->set('rights_read', $rights_read);
  }

  /**
   * Gets the value of the update access right.
   *
   * @return bool
   *   True if user can update the item.
   */
  public function getRightsUpdate() {
    return $this->get('rights_update');
  }

  /**
   * Sets a new value for the update access right.
   *
   * @param bool $rights_update
   *   If true referenced user will be able to update entity.
   */
  public function setRightsUpdate($rights_update) {
    return $this->set('rights_update', $rights_update);
  }

  /**
   * Gets the value of the delete access right.
   *
   * @return bool
   *   True if user can delete the item.
   */
  public function getRightsDelete() {
    return $this->get('rights_delete');
  }

  /**
   * Sets a new value for the delete access right.
   *
   * @param bool $rights_delete
   *   If true referenced user will be able to delete entity.
   */
  public function setRightsDelete($rights_delete) {
    return $this->set('rights_delete', $rights_delete);
  }

}
