<?php

namespace Drupal\access_by_ref\Plugin\migrate\process;

use Drupal\migrate\ProcessPluginBase;
use Drupal\migrate\MigrateExecutableInterface;
use Drupal\migrate\Row;

/**
 * Access by Reference Drupal 7 configuration process plugin.
 *
 * Processes Access by Reference Drupal 7 configuration by
 * splitting lines and converting each line into an array
 * that is compatible with the Abrconfig config entity definition.
 *
 * @MigrateProcessPlugin(
 *   id = "d7_access_by_ref",
 * )
 */
class D7AccessByRef extends ProcessPluginBase {

  /**
   * {@inheritdoc}
   */
  public function transform($value, MigrateExecutableInterface $migrate_executable, Row $row, $destination_property) {
    $variable_name = $row->getSourceProperty('variable_name');
    $bundle = $row->getSourceProperty('bundle');
    $field = $row->getSourceProperty('field');

    $mapping = $this->configuration['mapping'] ?? [];

    $reference_type = $mapping[$variable_name] ?? $variable_name;

    $fields = [
      'id' => implode('__', [$reference_type, $bundle, $field]),
      'label' => implode('|', [$bundle, $field]),
      'bundle' => $bundle,
      'field' => $field,
      'reference_type' => $reference_type,
      'extra' => NULL,
      // @todo verify default config.
      'rights_type' => 'view',
      'rights_read' => TRUE,
      'rights_update' => TRUE,
      'rights_delete' => FALSE,
    ];

    foreach ($fields as $field => $value) {
      $row->setDestinationProperty($field, $value);
    }

    return NULL;
  }

}
