/**
 * @file
 * Attaches next behavior for contrast functionality.
 */

(function (Drupal, drupalSettings) {

  let init = false;

  Drupal.behaviors.a11y_contrast = {
    attach: function (context, settings) {
      let b = this;

      if (!init) {
        init = true;

        b.init(b);

        let input = document.querySelector('.a11y-contrast-control');
        input.addEventListener('click', (e) => {
          b.dispatcher(e, b);
        });
      }
    },

    init: function (b) {
      let input = document.querySelector('.a11y-contrast-control');
      let container  = document.querySelector('.dialog-off-canvas-main-canvas'); // Modifier le sélecteur ici

      if (Cookies.get('a11y_contrast') === 'true') {
        b.bodyAlter(container, true);
        container.classList.add('a11y-contrast');
        input.classList.add('is-active');
      }
      else {
        b.bodyAlter(container, false);
        container.classList.remove('a11y-contrast');
        input.classList.remove('is-active');
      }
    },

    dispatcher: function (context, b) {
      let input = context.currentTarget;
      let container  = document.querySelector('.dialog-off-canvas-main-canvas'); // Modifier le sélecteur ici
      let value = null;

      if (input.classList.contains('is-active')) {
        value = false;
        input.classList.remove('is-active');
        container.classList.remove('a11y-contrast');
        b.bodyAlter(container, value);
      }
      else {
        value = true;
        input.classList.add('is-active');
        container.classList.add('a11y-contrast');
        b.bodyAlter(container, value);
      }

      Cookies.set('a11y_contrast', value, {path: '/'});
    },

    bodyAlter: function(container, mode) {
      let props = container.style.filter.split(' ');

      if (mode) {
        props.push('contrast(2)');
        container.style.filter = props.join(' ');
      }
      else {
        props = props.filter(prop => prop !== 'contrast(2)');
        container.style.filter = props.join(' ');
      }
    }

  }

})(Drupal, drupalSettings);
