/**
 * @file
 * Attaches next behavior for invert functionality.
 */

(function (Drupal, drupalSettings) {

  let init = false;

  Drupal.behaviors.a11y_invert = {
    attach: function (context, settings) {
      let b = this;

      if (!init) {
        init = true;

        b.init(b);

        let input = document.querySelector('.a11y-invert-control');
        input.addEventListener('click', (e) => {
          b.dispatcher(e, b);
        });
      }
    },

    init: function (b) {
      let input = document.querySelector('.a11y-invert-control');
      let container  = document.querySelector('.dialog-off-canvas-main-canvas');

      if (Cookies.get('a11y_invert') === 'true') {
        b.bodyAlter(container, true);
        container.classList.add('a11y-invert');
        input.classList.add('is-active');
      }
      else {
        b.bodyAlter(container, false);
        container.classList.remove('a11y-invert');
        input.classList.remove('is-active');
      }
    },

    dispatcher: function (context, b) {
      let input = context.currentTarget;
      let container  = document.querySelector('.dialog-off-canvas-main-canvas');
      let value = null;

      if (input.classList.contains('is-active')) {
        value = false;
        input.classList.remove('is-active');
        container.classList.remove('a11y-invert');
        b.bodyAlter(container, value);
      }
      else {
        value = true;
        input.classList.add('is-active');
        container.classList.add('a11y-invert');
        b.bodyAlter(container, value);
      }

      Cookies.set('a11y_invert', value, {path: '/'});
    },

    bodyAlter: function(container, mode) {
      let props = container.style.filter.split(' ');

      if (mode) {
        props.push('invert(1)');
        container.style.filter = props.join(' ');
      }
      else {
        props = props.filter(prop => prop !== 'invert(1)');
        container.style.filter = props.join(' ');
      }
    }

  }

})(Drupal, drupalSettings);
