<?php

declare(strict_types=1);

namespace Drupal\account_portal\Routing;

use Drupal\Core\Routing\RouteSubscriberBase;
use Symfony\Component\DependencyInjection\Attribute\Autowire;
use Symfony\Component\Routing\RouteCollection;

/**
 * Listens to the dynamic route events.
 */
class RouteSubscriber extends RouteSubscriberBase {

  public function __construct(
    #[Autowire(param: 'account_portal.routes')]
    protected readonly array $routes,
  ) {}

  /**
   * Alter routes.
   *
   * Marks all routes in the `account_portal.routes` service parameter
   * with the `_account_portal` default value.
   *
   * This is needed in order to distinguish paths in the path processor.
   *
   * {@inheritdoc}
   */
  protected function alterRoutes(RouteCollection $collection) {
    // Set the _account_portal default value for each
    // configured route in `account_portal.routes` parameter.
    foreach ($this->routes as $routeName) {
      if ($route = $collection->get($routeName)) {
        $route->setDefault('_account_portal', TRUE);
      }
    }
  }

}
