<?php

declare(strict_types=1);

namespace Drupal\Tests\account_portal\Functional;

use Drupal\Tests\BrowserTestBase;

/**
 * Test acount portal.
 */
class AccountPortalTest extends BrowserTestBase {

  /**
   * {@inheritdoc}
   */
  protected static $modules = [
    'consumers',
    'account_portal',
  ];

  /**
   * {@inheritdoc}
   */
  protected $defaultTheme = 'stark';

  /**
   * Test rewrite.
   */
  public function testRewrite() {
    $html = $this->drupalGet('account-portal/realm/default_consumer/user/login');

    $this->assertStringContainsString('<h1>Log in</h1>', $html);
    $this->assertStringContainsString('action="/account-portal/realm/default_consumer/user/login"', $html);
  }

  /**
   * Test invalid consumer redirect.
   */
  public function testInvalidConsumerRedirect() {
    $html = $this->drupalGet('account-portal/realm/invalid-id/user/login');

    $this->assertStringContainsString('<h1>Log in</h1>', $html);
    $this->assertStringContainsString('action="/"', $html);
  }

  /**
   * Test disabled invalid consumer redirect.
   */
  public function testDisabledInvalidConsumerRedirect() {
    $this->setContainerParameter('account_portal.invalid_consumer_id_destination', NULL);
    $this->rebuildContainer();

    $html = $this->drupalGet('account-portal/realm/invalid-id/user/login');

    $this->assertStringContainsString('<h1>Log in</h1>', $html);
    $this->assertStringContainsString('action="/account-portal/realm/invalid-id/user/login"', $html);
  }

}
