<?php

namespace Drupal\Tests\acquia_contenthub\Kernel;

/**
 * Tests importing and exporting nodes.
 *
 * @group acquia_contenthub
 *
 * @package Drupal\Tests\acquia_contenthub\Kernel
 */
class NodeImportUpdateExportTest extends ImportExportTestBase {

  /**
   * {@inheritdoc}
   */
  protected $fixtures = [
    [
      'cdf' => 'node/node_page.json',
      'expectations' => 'expectations/node/node_page.php',
    ],
    [
      'cdf' => 'node/node_page_update.json',
      'expectations' => 'expectations/node/node_page_update.php',
    ],
    [
      'cdf' => 'node/node_term_page.json',
      'expectations' => 'expectations/node/node_term_page.php',
    ],
    [
      'cdf' => 'node/node_term_page_update.json',
      'expectations' => 'expectations/node/node_term_page_update.php',
    ],
  ];

  /**
   * {@inheritdoc}
   */
  protected static $modules = [
    'system',
    'user',
    'node',
    'field',
    'depcalc',
    'acquia_contenthub',
    'acquia_contenthub_subscriber',
    'taxonomy',
  ];

  /**
   * EntityCdfSerializer service.
   *
   * @var \Drupal\acquia_contenthub\EntityCdfSerializer
   */
  protected $serializer;

  /**
   * {@inheritdoc}
   *
   * @throws \Exception
   */
  protected function setup(): void {
    parent::setUp();
    $this->installEntitySchema('user');
    $this->installSchema('user', ['users_data']);
    $this->installEntitySchema('node');
    $this->installSchema('node', ['node_access']);
    $this->installSchema('acquia_contenthub_subscriber', 'acquia_contenthub_subscriber_import_tracking');
    $this->installEntitySchema('taxonomy_term');
  }

  /**
   * Tests Node entity create and update.
   *
   * @param int $delta
   *   Fixture delta.
   * @param int $update_delta
   *   "Update" fixture delta.
   * @param array $validate_data
   *   Data.
   * @param string $export_type
   *   Exported entity type.
   * @param string $export_uuid
   *   Entity UUID.
   *
   * @throws \Drupal\Core\Entity\EntityStorageException
   *
   * @dataProvider nodeImportUpdateExportDataProvider
   */
  public function testNodeImportUpdateExport(int $delta, int $update_delta, array $validate_data, string $export_type, string $export_uuid): void {
    $this->enableContentModeration();

    parent::contentEntityImportExport($delta, $validate_data, $export_type, $export_uuid);
    parent::contentEntityImportExport($update_delta, $validate_data, $export_type, $export_uuid);

    /** @var \Drupal\Core\Entity\EntityRepository $repository */
    $repository = \Drupal::service('entity.repository');
    /** @var \Drupal\Node\NodeStorageInterface $node_storage */
    $node_storage = \Drupal::entityTypeManager()->getStorage('node');

    /** @var \Drupal\Node\NodeInterface $node */
    $node = $repository->loadEntityByUuid($export_type, $export_uuid);
    $vids = $node_storage->revisionIds($node);
    $this->assertEquals(2, count($vids), "New revision created on import.");

  }

  /**
   * Data provider for testNodeImportUpdateExport.
   *
   * @return array
   *   Data provider for testNodeImportUpdateExport.
   */
  public static function nodeImportUpdateExportDataProvider(): array {
    $export_uuid = [
      '5d1ba3c3-d527-4328-8fce-a6b714c5ef79',
      '40253012-2a03-47c1-86b8-87e4d0adf091',
    ];
    return [
      [
        0,
        1,
        [['type' => 'node', 'uuid' => $export_uuid[0]]],
        'node',
        $export_uuid[0],
      ],
      [
        2,
        3,
        [['type' => 'node', 'uuid' => $export_uuid[1]]],
        'node',
        $export_uuid[1],
      ],
    ];
  }

}
