<?php

namespace Drupal\acquia_cookie_vary\Form;

use Drupal\Core\Form\ConfigFormBase;
use Drupal\Core\Form\ConfigTarget;
use Drupal\Core\Form\FormStateInterface;

/**
 * Settings form for the module.
 */
class SettingsForm extends ConfigFormBase {

  /**
   * {@inheritdoc}
   */
  protected function getEditableConfigNames() {
    return ['acquia_cookie_vary.settings'];
  }

  /**
   * {@inheritdoc}
   */
  public function getFormId() {
    return 'acquia_cookie_vary_settings';
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state) {

    $config = $this->config('acquia_cookie_vary.settings');

    $form['custom_cookie'] = [
      '#type' => 'textfield',
      '#title' => $this->t('Custom cookie name'),
      '#description' => $this->t('The Acquia platform allows for <a href="@link">a single end-user named cookie</a> to be used in addition to the standard platform cookies.', [
        '@link' => 'https://docs.acquia.com/acquia-cloud-platform/docs/performance/varnish/cookies#section-example-one-parsing-a-custom-cookie',
      ]),
      '#default_value' => $config->get('custom_cookie'),
      '#config_target' => new ConfigTarget(
        'acquia_cookie_vary.settings',
        'custom_cookie',
      ),
    ];

    $form['debug'] = [
      '#type' => 'checkbox',
      '#title' => $this->t('Enable debug headers'),
      '#description' => $this->t('If enabled, various X-Acquia-Cookie-* headers may be added to responses.'),
      '#default_value' => $config->get('debug'),
      '#config_target' => new ConfigTarget(
        'acquia_cookie_vary.settings',
        'debug',
      ),
    ];
    return parent::buildForm($form, $form_state);
  }

}
