<?php

namespace Drupal\Tests\acquia_cookie_vary\Functional;

use Drupal\Core\Url;
use Drupal\Tests\BrowserTestBase;

/**
 * Functional test cases for the response subscriber.
 *
 * @group acquia_cookie_vary
 */
class ResponseSubscriberTest extends BrowserTestBase {

  /**
   * {@inheritdoc}
   */
  protected static $modules = [
    'acquia_cookie_vary',
    'acquia_cookie_vary_test',
  ];

  /**
   * {@inheritdoc}
   */
  protected $defaultTheme = 'stark';

  /**
   * {@inheritdoc}
   */
  protected function setUp(): void {
    parent::setUp();

    // Set up CORS...
    $this->setContainerParameter('cors.config', [
      'enabled' => TRUE,
      'allowedHeaders' => [],
      'allowedMethods' => ['GET'],
      'allowedOrigins' => ['https://example.com', 'https://subdomain.example.com'],
      'exposedHeaders' => FALSE,
      'maxAge' => FALSE,
      'supportsCredentials' => FALSE,
    ]);

    $this->rebuildContainer();
  }

  /**
   * Test case for the response subscriber.
   */
  public function testResponseSubscriber() {
    $this->drupalGet(Url::fromRoute('<front>'));

    static::assertStringContainsString('X-Acquia-Cookie-A', $this->getSession()->getResponseHeader('Vary'));
  }

}
